@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a timer trigger.
 * @property name The name of the trigger.
 * @property schedule The CRON expression for the task schedule
 * @property status The current status of trigger.
 */
public data class TimerTriggerResponse(
    public val name: String,
    public val schedule: String,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TimerTriggerResponse):
            TimerTriggerResponse = TimerTriggerResponse(
            name = javaType.name(),
            schedule = javaType.schedule(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
