@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getAgentPoolPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getFleetMemberPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getFleetPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getFleetUpdateStrategyPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getMaintenanceConfigurationPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getManagedClusterPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getManagedClusterSnapshotPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getOpenShiftManagedClusterPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getSnapshotPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getTrustedAccessRoleBindingPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.getUpdateRunPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.listFleetCredentialsPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.listManagedClusterAccessProfilePlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.listManagedClusterAdminCredentialsPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.listManagedClusterMonitoringUserCredentialsPlain
import com.pulumi.azurenative.containerservice.ContainerserviceFunctions.listManagedClusterUserCredentialsPlain
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetAgentPoolPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetAgentPoolPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetMemberPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetMemberPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetUpdateStrategyPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetFleetUpdateStrategyPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetMaintenanceConfigurationPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetMaintenanceConfigurationPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetManagedClusterPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetManagedClusterPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetManagedClusterSnapshotPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetManagedClusterSnapshotPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetOpenShiftManagedClusterPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetOpenShiftManagedClusterPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetTrustedAccessRoleBindingPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetTrustedAccessRoleBindingPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetUpdateRunPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.GetUpdateRunPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListFleetCredentialsPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListFleetCredentialsPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterAccessProfilePlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterAccessProfilePlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterAdminCredentialsPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterAdminCredentialsPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterMonitoringUserCredentialsPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterMonitoringUserCredentialsPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterUserCredentialsPlainArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ListManagedClusterUserCredentialsPlainArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetAgentPoolResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetMemberResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetUpdateStrategyResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetMaintenanceConfigurationResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetManagedClusterResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetManagedClusterSnapshotResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetOpenShiftManagedClusterResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetSnapshotResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetTrustedAccessRoleBindingResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetUpdateRunResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListFleetCredentialsResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterAccessProfileResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterAdminCredentialsResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterMonitoringUserCredentialsResult
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterUserCredentialsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetAgentPoolResult.Companion.toKotlin as getAgentPoolResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetMemberResult.Companion.toKotlin as getFleetMemberResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetResult.Companion.toKotlin as getFleetResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetFleetUpdateStrategyResult.Companion.toKotlin as getFleetUpdateStrategyResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetMaintenanceConfigurationResult.Companion.toKotlin as getMaintenanceConfigurationResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetManagedClusterResult.Companion.toKotlin as getManagedClusterResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetManagedClusterSnapshotResult.Companion.toKotlin as getManagedClusterSnapshotResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetOpenShiftManagedClusterResult.Companion.toKotlin as getOpenShiftManagedClusterResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetTrustedAccessRoleBindingResult.Companion.toKotlin as getTrustedAccessRoleBindingResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.GetUpdateRunResult.Companion.toKotlin as getUpdateRunResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListFleetCredentialsResult.Companion.toKotlin as listFleetCredentialsResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterAccessProfileResult.Companion.toKotlin as listManagedClusterAccessProfileResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterAdminCredentialsResult.Companion.toKotlin as listManagedClusterAdminCredentialsResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterMonitoringUserCredentialsResult.Companion.toKotlin as listManagedClusterMonitoringUserCredentialsResultToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.ListManagedClusterUserCredentialsResult.Companion.toKotlin as listManagedClusterUserCredentialsResultToKotlin

public object ContainerserviceFunctions {
    /**
     * Agent Pool.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2019-02-01, 2019-04-01, 2020-06-01, 2021-02-01, 2021-08-01, 2022-04-02-preview, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return Agent Pool.
     */
    public suspend fun getAgentPool(argument: GetAgentPoolPlainArgs): GetAgentPoolResult =
        getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())

    /**
     * @see [getAgentPool].
     * @param agentPoolName The name of the agent pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return Agent Pool.
     */
    public suspend fun getAgentPool(
        agentPoolName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetAgentPoolResult {
        val argument = GetAgentPoolPlainArgs(
            agentPoolName = agentPoolName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getAgentPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetAgentPoolPlainArgs].
     * @return Agent Pool.
     */
    public suspend fun getAgentPool(argument: suspend GetAgentPoolPlainArgsBuilder.() -> Unit):
        GetAgentPoolResult {
        val builder = GetAgentPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAgentPoolResultToKotlin(getAgentPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Fleet.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
     * @param argument null
     * @return The Fleet resource.
     */
    public suspend fun getFleet(argument: GetFleetPlainArgs): GetFleetResult =
        getFleetResultToKotlin(getFleetPlain(argument.toJava()).await())

    /**
     * @see [getFleet].
     * @param fleetName The name of the Fleet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Fleet resource.
     */
    public suspend fun getFleet(fleetName: String, resourceGroupName: String): GetFleetResult {
        val argument = GetFleetPlainArgs(
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
        )
        return getFleetResultToKotlin(getFleetPlain(argument.toJava()).await())
    }

    /**
     * @see [getFleet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetFleetPlainArgs].
     * @return The Fleet resource.
     */
    public suspend fun getFleet(argument: suspend GetFleetPlainArgsBuilder.() -> Unit):
        GetFleetResult {
        val builder = GetFleetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFleetResultToKotlin(getFleetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a FleetMember
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
     * @param argument null
     * @return A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
     */
    public suspend fun getFleetMember(argument: GetFleetMemberPlainArgs): GetFleetMemberResult =
        getFleetMemberResultToKotlin(getFleetMemberPlain(argument.toJava()).await())

    /**
     * @see [getFleetMember].
     * @param fleetMemberName The name of the Fleet member resource.
     * @param fleetName The name of the Fleet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
     */
    public suspend fun getFleetMember(
        fleetMemberName: String,
        fleetName: String,
        resourceGroupName: String,
    ): GetFleetMemberResult {
        val argument = GetFleetMemberPlainArgs(
            fleetMemberName = fleetMemberName,
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
        )
        return getFleetMemberResultToKotlin(getFleetMemberPlain(argument.toJava()).await())
    }

    /**
     * @see [getFleetMember].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetFleetMemberPlainArgs].
     * @return A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
     */
    public suspend fun getFleetMember(argument: suspend GetFleetMemberPlainArgsBuilder.() -> Unit):
        GetFleetMemberResult {
        val builder = GetFleetMemberPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFleetMemberResultToKotlin(getFleetMemberPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a FleetUpdateStrategy
     * Azure REST API version: 2023-08-15-preview.
     * Other available API versions: 2023-10-15.
     * @param argument null
     * @return Defines a multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend fun getFleetUpdateStrategy(argument: GetFleetUpdateStrategyPlainArgs):
        GetFleetUpdateStrategyResult =
        getFleetUpdateStrategyResultToKotlin(getFleetUpdateStrategyPlain(argument.toJava()).await())

    /**
     * @see [getFleetUpdateStrategy].
     * @param fleetName The name of the Fleet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param updateStrategyName The name of the UpdateStrategy resource.
     * @return Defines a multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend fun getFleetUpdateStrategy(
        fleetName: String,
        resourceGroupName: String,
        updateStrategyName: String,
    ): GetFleetUpdateStrategyResult {
        val argument = GetFleetUpdateStrategyPlainArgs(
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
            updateStrategyName = updateStrategyName,
        )
        return getFleetUpdateStrategyResultToKotlin(getFleetUpdateStrategyPlain(argument.toJava()).await())
    }

    /**
     * @see [getFleetUpdateStrategy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetFleetUpdateStrategyPlainArgs].
     * @return Defines a multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend
    fun getFleetUpdateStrategy(argument: suspend GetFleetUpdateStrategyPlainArgsBuilder.() -> Unit):
        GetFleetUpdateStrategyResult {
        val builder = GetFleetUpdateStrategyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFleetUpdateStrategyResultToKotlin(getFleetUpdateStrategyPlain(builtArgument.toJava()).await())
    }

    /**
     * See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
     */
    public suspend fun getMaintenanceConfiguration(argument: GetMaintenanceConfigurationPlainArgs):
        GetMaintenanceConfigurationResult =
        getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getMaintenanceConfiguration].
     * @param configName The name of the maintenance configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
     */
    public suspend fun getMaintenanceConfiguration(
        configName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetMaintenanceConfigurationResult {
        val argument = GetMaintenanceConfigurationPlainArgs(
            configName = configName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getMaintenanceConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetMaintenanceConfigurationPlainArgs].
     * @return See [planned maintenance](https://docs.microsoft.com/azure/aks/planned-maintenance) for more information about planned maintenance.
     */
    public suspend
    fun getMaintenanceConfiguration(argument: suspend GetMaintenanceConfigurationPlainArgsBuilder.() -> Unit):
        GetMaintenanceConfigurationResult {
        val builder = GetMaintenanceConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMaintenanceConfigurationResultToKotlin(getMaintenanceConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Managed cluster.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2017-08-31, 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return Managed cluster.
     */
    public suspend fun getManagedCluster(argument: GetManagedClusterPlainArgs):
        GetManagedClusterResult =
        getManagedClusterResultToKotlin(getManagedClusterPlain(argument.toJava()).await())

    /**
     * @see [getManagedCluster].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return Managed cluster.
     */
    public suspend fun getManagedCluster(resourceGroupName: String, resourceName: String):
        GetManagedClusterResult {
        val argument = GetManagedClusterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getManagedClusterResultToKotlin(getManagedClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetManagedClusterPlainArgs].
     * @return Managed cluster.
     */
    public suspend
    fun getManagedCluster(argument: suspend GetManagedClusterPlainArgsBuilder.() -> Unit):
        GetManagedClusterResult {
        val builder = GetManagedClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterResultToKotlin(getManagedClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * A managed cluster snapshot resource.
     * Azure REST API version: 2023-05-02-preview.
     * Other available API versions: 2023-06-02-preview, 2023-07-02-preview, 2023-08-02-preview, 2023-09-02-preview, 2023-10-02-preview.
     * @param argument null
     * @return A managed cluster snapshot resource.
     */
    public suspend fun getManagedClusterSnapshot(argument: GetManagedClusterSnapshotPlainArgs):
        GetManagedClusterSnapshotResult =
        getManagedClusterSnapshotResultToKotlin(getManagedClusterSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getManagedClusterSnapshot].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return A managed cluster snapshot resource.
     */
    public suspend fun getManagedClusterSnapshot(resourceGroupName: String, resourceName: String):
        GetManagedClusterSnapshotResult {
        val argument = GetManagedClusterSnapshotPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getManagedClusterSnapshotResultToKotlin(getManagedClusterSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedClusterSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetManagedClusterSnapshotPlainArgs].
     * @return A managed cluster snapshot resource.
     */
    public suspend
    fun getManagedClusterSnapshot(argument: suspend GetManagedClusterSnapshotPlainArgsBuilder.() -> Unit):
        GetManagedClusterSnapshotResult {
        val builder = GetManagedClusterSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedClusterSnapshotResultToKotlin(getManagedClusterSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the managed OpenShift cluster with a specified resource group and name.
     * Azure REST API version: 2019-10-27-preview.
     * Other available API versions: 2018-09-30-preview.
     * @param argument null
     * @return OpenShift Managed cluster.
     */
    public suspend fun getOpenShiftManagedCluster(argument: GetOpenShiftManagedClusterPlainArgs):
        GetOpenShiftManagedClusterResult =
        getOpenShiftManagedClusterResultToKotlin(getOpenShiftManagedClusterPlain(argument.toJava()).await())

    /**
     * @see [getOpenShiftManagedCluster].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the OpenShift managed cluster resource.
     * @return OpenShift Managed cluster.
     */
    public suspend fun getOpenShiftManagedCluster(resourceGroupName: String, resourceName: String):
        GetOpenShiftManagedClusterResult {
        val argument = GetOpenShiftManagedClusterPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getOpenShiftManagedClusterResultToKotlin(getOpenShiftManagedClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenShiftManagedCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetOpenShiftManagedClusterPlainArgs].
     * @return OpenShift Managed cluster.
     */
    public suspend
    fun getOpenShiftManagedCluster(argument: suspend GetOpenShiftManagedClusterPlainArgsBuilder.() -> Unit):
        GetOpenShiftManagedClusterResult {
        val builder = GetOpenShiftManagedClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenShiftManagedClusterResultToKotlin(getOpenShiftManagedClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * To learn more about private clusters, see: https://docs.microsoft.com/azure/aks/private-clusters
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * A node pool snapshot resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return A node pool snapshot resource.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @return A node pool snapshot resource.
     */
    public suspend fun getSnapshot(resourceGroupName: String, resourceName: String):
        GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A node pool snapshot resource.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit):
        GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Defines binding between a resource and role
     * Azure REST API version: 2023-05-02-preview.
     * Other available API versions: 2023-06-02-preview, 2023-07-02-preview, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return Defines binding between a resource and role
     */
    public suspend fun getTrustedAccessRoleBinding(argument: GetTrustedAccessRoleBindingPlainArgs):
        GetTrustedAccessRoleBindingResult =
        getTrustedAccessRoleBindingResultToKotlin(getTrustedAccessRoleBindingPlain(argument.toJava()).await())

    /**
     * @see [getTrustedAccessRoleBinding].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @return Defines binding between a resource and role
     */
    public suspend fun getTrustedAccessRoleBinding(
        resourceGroupName: String,
        resourceName: String,
        trustedAccessRoleBindingName: String,
    ): GetTrustedAccessRoleBindingResult {
        val argument = GetTrustedAccessRoleBindingPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            trustedAccessRoleBindingName = trustedAccessRoleBindingName,
        )
        return getTrustedAccessRoleBindingResultToKotlin(getTrustedAccessRoleBindingPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrustedAccessRoleBinding].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetTrustedAccessRoleBindingPlainArgs].
     * @return Defines binding between a resource and role
     */
    public suspend
    fun getTrustedAccessRoleBinding(argument: suspend GetTrustedAccessRoleBindingPlainArgsBuilder.() -> Unit):
        GetTrustedAccessRoleBindingResult {
        val builder = GetTrustedAccessRoleBindingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrustedAccessRoleBindingResultToKotlin(getTrustedAccessRoleBindingPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a UpdateRun
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
     * @param argument null
     * @return A multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend fun getUpdateRun(argument: GetUpdateRunPlainArgs): GetUpdateRunResult =
        getUpdateRunResultToKotlin(getUpdateRunPlain(argument.toJava()).await())

    /**
     * @see [getUpdateRun].
     * @param fleetName The name of the Fleet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param updateRunName The name of the UpdateRun resource.
     * @return A multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend fun getUpdateRun(
        fleetName: String,
        resourceGroupName: String,
        updateRunName: String,
    ): GetUpdateRunResult {
        val argument = GetUpdateRunPlainArgs(
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
            updateRunName = updateRunName,
        )
        return getUpdateRunResultToKotlin(getUpdateRunPlain(argument.toJava()).await())
    }

    /**
     * @see [getUpdateRun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;GetUpdateRunPlainArgs].
     * @return A multi-stage process to perform update operations across members of a Fleet.
     */
    public suspend fun getUpdateRun(argument: suspend GetUpdateRunPlainArgsBuilder.() -> Unit):
        GetUpdateRunResult {
        val builder = GetUpdateRunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUpdateRunResultToKotlin(getUpdateRunPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the user credentials of a Fleet.
     * Azure REST API version: 2023-03-15-preview.
     * Other available API versions: 2022-07-02-preview, 2023-06-15-preview, 2023-08-15-preview, 2023-10-15.
     * @param argument null
     * @return The Credential results response.
     */
    public suspend fun listFleetCredentials(argument: ListFleetCredentialsPlainArgs):
        ListFleetCredentialsResult =
        listFleetCredentialsResultToKotlin(listFleetCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listFleetCredentials].
     * @param fleetName The name of the Fleet resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Credential results response.
     */
    public suspend fun listFleetCredentials(fleetName: String, resourceGroupName: String):
        ListFleetCredentialsResult {
        val argument = ListFleetCredentialsPlainArgs(
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
        )
        return listFleetCredentialsResultToKotlin(listFleetCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listFleetCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;ListFleetCredentialsPlainArgs].
     * @return The Credential results response.
     */
    public suspend
    fun listFleetCredentials(argument: suspend ListFleetCredentialsPlainArgsBuilder.() -> Unit):
        ListFleetCredentialsResult {
        val builder = ListFleetCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFleetCredentialsResultToKotlin(listFleetCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the accessProfile for the specified role name of the managed cluster with a specified resource group and name.
     * Azure REST API version: 2020-03-01.
     * Other available API versions: 2017-08-31, 2019-02-01, 2019-06-01.
     * @param argument null
     * @return Managed cluster Access Profile.
     */
    public suspend
    fun listManagedClusterAccessProfile(argument: ListManagedClusterAccessProfilePlainArgs):
        ListManagedClusterAccessProfileResult =
        listManagedClusterAccessProfileResultToKotlin(listManagedClusterAccessProfilePlain(argument.toJava()).await())

    /**
     * @see [listManagedClusterAccessProfile].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param roleName The name of the role for managed cluster accessProfile resource.
     * @return Managed cluster Access Profile.
     */
    public suspend fun listManagedClusterAccessProfile(
        resourceGroupName: String,
        resourceName: String,
        roleName: String,
    ): ListManagedClusterAccessProfileResult {
        val argument = ListManagedClusterAccessProfilePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            roleName = roleName,
        )
        return listManagedClusterAccessProfileResultToKotlin(listManagedClusterAccessProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [listManagedClusterAccessProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;ListManagedClusterAccessProfilePlainArgs].
     * @return Managed cluster Access Profile.
     */
    public suspend
    fun listManagedClusterAccessProfile(argument: suspend ListManagedClusterAccessProfilePlainArgsBuilder.() -> Unit):
        ListManagedClusterAccessProfileResult {
        val builder = ListManagedClusterAccessProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagedClusterAccessProfileResultToKotlin(listManagedClusterAccessProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * The list credential result response.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterAdminCredentials(argument: ListManagedClusterAdminCredentialsPlainArgs):
        ListManagedClusterAdminCredentialsResult =
        listManagedClusterAdminCredentialsResultToKotlin(listManagedClusterAdminCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listManagedClusterAdminCredentials].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param serverFqdn server fqdn type for credentials to be returned
     * @return The list credential result response.
     */
    public suspend fun listManagedClusterAdminCredentials(
        resourceGroupName: String,
        resourceName: String,
        serverFqdn: String? = null,
    ): ListManagedClusterAdminCredentialsResult {
        val argument = ListManagedClusterAdminCredentialsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            serverFqdn = serverFqdn,
        )
        return listManagedClusterAdminCredentialsResultToKotlin(listManagedClusterAdminCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listManagedClusterAdminCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;ListManagedClusterAdminCredentialsPlainArgs].
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterAdminCredentials(argument: suspend ListManagedClusterAdminCredentialsPlainArgsBuilder.() -> Unit):
        ListManagedClusterAdminCredentialsResult {
        val builder = ListManagedClusterAdminCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagedClusterAdminCredentialsResultToKotlin(listManagedClusterAdminCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * The list credential result response.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterMonitoringUserCredentials(argument: ListManagedClusterMonitoringUserCredentialsPlainArgs):
        ListManagedClusterMonitoringUserCredentialsResult =
        listManagedClusterMonitoringUserCredentialsResultToKotlin(listManagedClusterMonitoringUserCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listManagedClusterMonitoringUserCredentials].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param serverFqdn server fqdn type for credentials to be returned
     * @return The list credential result response.
     */
    public suspend fun listManagedClusterMonitoringUserCredentials(
        resourceGroupName: String,
        resourceName: String,
        serverFqdn: String? = null,
    ): ListManagedClusterMonitoringUserCredentialsResult {
        val argument = ListManagedClusterMonitoringUserCredentialsPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            serverFqdn = serverFqdn,
        )
        return listManagedClusterMonitoringUserCredentialsResultToKotlin(listManagedClusterMonitoringUserCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listManagedClusterMonitoringUserCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;ListManagedClusterMonitoringUserCredentialsPlainArgs].
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterMonitoringUserCredentials(argument: suspend ListManagedClusterMonitoringUserCredentialsPlainArgsBuilder.() -> Unit):
        ListManagedClusterMonitoringUserCredentialsResult {
        val builder = ListManagedClusterMonitoringUserCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagedClusterMonitoringUserCredentialsResultToKotlin(listManagedClusterMonitoringUserCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * The list credential result response.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
     * @param argument null
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterUserCredentials(argument: ListManagedClusterUserCredentialsPlainArgs):
        ListManagedClusterUserCredentialsResult =
        listManagedClusterUserCredentialsResultToKotlin(listManagedClusterUserCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listManagedClusterUserCredentials].
     * @param format Only apply to AAD clusters, specifies the format of returned kubeconfig. Format 'azure' will return azure auth-provider kubeconfig; format 'exec' will return exec format kubeconfig, which requires kubelogin binary in the path.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param serverFqdn server fqdn type for credentials to be returned
     * @return The list credential result response.
     */
    public suspend fun listManagedClusterUserCredentials(
        format: String? = null,
        resourceGroupName: String,
        resourceName: String,
        serverFqdn: String? = null,
    ): ListManagedClusterUserCredentialsResult {
        val argument = ListManagedClusterUserCredentialsPlainArgs(
            format = format,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            serverFqdn = serverFqdn,
        )
        return listManagedClusterUserCredentialsResultToKotlin(listManagedClusterUserCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listManagedClusterUserCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerservice&#46;kotlin&#46;inputs&#46;ListManagedClusterUserCredentialsPlainArgs].
     * @return The list credential result response.
     */
    public suspend
    fun listManagedClusterUserCredentials(argument: suspend ListManagedClusterUserCredentialsPlainArgsBuilder.() -> Unit):
        ListManagedClusterUserCredentialsResult {
        val builder = ListManagedClusterUserCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listManagedClusterUserCredentialsResultToKotlin(listManagedClusterUserCredentialsPlain(builtArgument.toJava()).await())
    }
}
