@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse.Companion.toKotlin as creationDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.Snapshot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Snapshot(builtJavaResource)
    }
}

/**
 * A node pool snapshot resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-08-01.
 * Other available API versions: 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview.
 * ## Example Usage
 * ### Create/Update Snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.ContainerService.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *         {
 *             SourceResourceId = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "snapshot1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *             { "key2", "val2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewSnapshot(ctx, "snapshot", &containerservice.SnapshotArgs{
 * 			CreationData: &containerservice.CreationDataArgs{
 * 				SourceResourceId: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("snapshot1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 				"key2": pulumi.String("val2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.Snapshot;
 * import com.pulumi.azurenative.containerservice.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.of("sourceResourceId", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1/agentPools/pool0"))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .resourceName("snapshot1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "val1"),
 *                 Map.entry("key2", "val2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:Snapshot snapshot1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/snapshots/{resourceName}
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * CreationData to be used to specify the source agent pool resource ID to create this snapshot.
     */
    public val creationData: Output<CreationDataResponse>?
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    creationDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Whether to use a FIPS-enabled OS.
     */
    public val enableFIPS: Output<Boolean>
        get() = javaResource.enableFIPS().applyValue({ args0 -> args0 })

    /**
     * The version of Kubernetes.
     */
    public val kubernetesVersion: Output<String>
        get() = javaResource.kubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The version of node image.
     */
    public val nodeImageVersion: Output<String>
        get() = javaResource.nodeImageVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    public val osSku: Output<String>
        get() = javaResource.osSku().applyValue({ args0 -> args0 })

    /**
     * The operating system type. The default is Linux.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * The type of a snapshot. The default is NodePool.
     */
    public val snapshotType: Output<String>?
        get() = javaResource.snapshotType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The size of the VM.
     */
    public val vmSize: Output<String>
        get() = javaResource.vmSize().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.azurenative.containerservice.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit):
    Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
