@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If not specified, the default is 'random'. See [expanders](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders) for more information.
 */
public enum class Expander(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.Expander,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.Expander> {
    /**
     * Selects the node group that will have the least idle CPU (if tied, unused memory) after scale-up. This is useful when you have different classes of nodes, for example, high CPU or high memory nodes, and only want to expand those when there are pending pods that need a lot of those resources.
     */
    Leastwaste(com.pulumi.azurenative.containerservice.enums.Expander.Leastwaste),

    /**
     * Selects the node group that would be able to schedule the most pods when scaling up. This is useful when you are using nodeSelector to make sure certain pods land on certain nodes. Note that this won't cause the autoscaler to select bigger nodes vs. smaller, as it can add multiple smaller nodes at once.
     */
    Mostpods(com.pulumi.azurenative.containerservice.enums.Expander.Mostpods),

    /**
     * Selects the node group that has the highest priority assigned by the user. It's configuration is described in more details [here](https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/expander/priority/readme.md).
     */
    Priority(com.pulumi.azurenative.containerservice.enums.Expander.Priority),

    /**
     * Used when you don't have a particular need for the node groups to scale differently.
     */
    Random(com.pulumi.azurenative.containerservice.enums.Expander.Random),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.Expander = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.Expander): Expander =
            Expander.values().first { it.javaValue == javaType }
    }
}
