@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
 */
public enum class GPUInstanceProfile(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile> {
    MIG1g(com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile.MIG1g),
    MIG2g(com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile.MIG2g),
    MIG3g(com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile.MIG3g),
    MIG4g(com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile.MIG4g),
    MIG7g(com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile.MIG7g),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.GPUInstanceProfile):
            GPUInstanceProfile = GPUInstanceProfile.values().first { it.javaValue == javaType }
    }
}
