@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The upgrade type.
 * Full requires the KubernetesVersion property to be set.
 * NodeImageOnly requires the KubernetesVersion property not to be set.
 */
public enum class ManagedClusterUpgradeType(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType> {
    /**
     * Full upgrades the control plane and all agent pools of the target ManagedClusters.
     */
    Full(com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType.Full),

    /**
     * NodeImageOnly upgrades only the node images of the target ManagedClusters.
     */
    NodeImageOnly(com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType.NodeImageOnly),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.ManagedClusterUpgradeType):
            ManagedClusterUpgradeType =
            ManagedClusterUpgradeType.values().first { it.javaValue == javaType }
    }
}
