@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
 */
public enum class OSSKU(
    public val javaValue: com.pulumi.azurenative.containerservice.enums.OSSKU,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.enums.OSSKU> {
    /**
     * Use Ubuntu as the OS for node images.
     */
    Ubuntu(com.pulumi.azurenative.containerservice.enums.OSSKU.Ubuntu),

    /**
     * Use AzureLinux as the OS for node images. Azure Linux is a container-optimized Linux distro built by Microsoft, visit https://aka.ms/azurelinux for more information.
     */
    AzureLinux(com.pulumi.azurenative.containerservice.enums.OSSKU.AzureLinux),

    /**
     * Deprecated OSSKU. Microsoft recommends that new deployments choose 'AzureLinux' instead.
     */
    CBLMariner(com.pulumi.azurenative.containerservice.enums.OSSKU.CBLMariner),

    /**
     * Use Windows2019 as the OS for node images. Unsupported for system node pools. Windows2019 only supports Windows2019 containers; it cannot run Windows2022 containers and vice versa.
     */
    Windows2019(com.pulumi.azurenative.containerservice.enums.OSSKU.Windows2019),

    /**
     * Use Windows2022 as the OS for node images. Unsupported for system node pools. Windows2022 only supports Windows2022 containers; it cannot run Windows2019 containers and vice versa.
     */
    Windows2022(com.pulumi.azurenative.containerservice.enums.OSSKU.Windows2022),
    ;

    override fun toJava(): com.pulumi.azurenative.containerservice.enums.OSSKU = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerservice.enums.OSSKU): OSSKU =
            OSSKU.values().first { it.javaValue == javaType }
    }
}
