@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.GetMaintenanceConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configName The name of the maintenance configuration.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 */
public data class GetMaintenanceConfigurationPlainArgs(
    public val configName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.GetMaintenanceConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.GetMaintenanceConfigurationPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.GetMaintenanceConfigurationPlainArgs.builder()
            .configName(configName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMaintenanceConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetMaintenanceConfigurationPlainArgsBuilder internal constructor() {
    private var configName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the maintenance configuration.
     */
    @JvmName("gagxwgrkfmssfbfl")
    public suspend fun configName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnismoikftphenvu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("mhnlufwfdyeqskii")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetMaintenanceConfigurationPlainArgs = GetMaintenanceConfigurationPlainArgs(
        configName = configName ?: throw PulumiNullFieldException("configName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
