@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ListManagedClusterUserCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Only apply to AAD clusters, specifies the format of returned kubeconfig. Format 'azure' will return azure auth-provider kubeconfig; format 'exec' will return exec format kubeconfig, which requires kubelogin binary in the path.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property serverFqdn server fqdn type for credentials to be returned
 */
public data class ListManagedClusterUserCredentialsPlainArgs(
    public val format: String? = null,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val serverFqdn: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ListManagedClusterUserCredentialsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ListManagedClusterUserCredentialsPlainArgs =
        com.pulumi.azurenative.containerservice.inputs.ListManagedClusterUserCredentialsPlainArgs.builder()
            .format(format?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .serverFqdn(serverFqdn?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListManagedClusterUserCredentialsPlainArgs].
 */
@PulumiTagMarker
public class ListManagedClusterUserCredentialsPlainArgsBuilder internal constructor() {
    private var format: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var serverFqdn: String? = null

    /**
     * @param value Only apply to AAD clusters, specifies the format of returned kubeconfig. Format 'azure' will return azure auth-provider kubeconfig; format 'exec' will return exec format kubeconfig, which requires kubelogin binary in the path.
     */
    @JvmName("wckxrfqaddpjdvsd")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("usofwwvcvxgpbiao")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("snbtrraajkwydpaf")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value server fqdn type for credentials to be returned
     */
    @JvmName("ejmigcocxdqxbsgv")
    public suspend fun serverFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serverFqdn = mapped
    }

    internal fun build(): ListManagedClusterUserCredentialsPlainArgs =
        ListManagedClusterUserCredentialsPlainArgs(
            format = format,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            serverFqdn = serverFqdn,
        )
}
