@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access profile for managed cluster API server.
 * @property authorizedIPRanges IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
 * @property disableRunCommand Whether to disable run command for the cluster or not.
 * @property enablePrivateCluster For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
 * @property enablePrivateClusterPublicFQDN Whether to create additional public FQDN for private cluster or not.
 * @property privateDNSZone The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
 */
public data class ManagedClusterAPIServerAccessProfileArgs(
    public val authorizedIPRanges: Output<List<String>>? = null,
    public val disableRunCommand: Output<Boolean>? = null,
    public val enablePrivateCluster: Output<Boolean>? = null,
    public val enablePrivateClusterPublicFQDN: Output<Boolean>? = null,
    public val privateDNSZone: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAPIServerAccessProfileArgs.builder()
            .authorizedIPRanges(authorizedIPRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .disableRunCommand(disableRunCommand?.applyValue({ args0 -> args0 }))
            .enablePrivateCluster(enablePrivateCluster?.applyValue({ args0 -> args0 }))
            .enablePrivateClusterPublicFQDN(enablePrivateClusterPublicFQDN?.applyValue({ args0 -> args0 }))
            .privateDNSZone(privateDNSZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterAPIServerAccessProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterAPIServerAccessProfileArgsBuilder internal constructor() {
    private var authorizedIPRanges: Output<List<String>>? = null

    private var disableRunCommand: Output<Boolean>? = null

    private var enablePrivateCluster: Output<Boolean>? = null

    private var enablePrivateClusterPublicFQDN: Output<Boolean>? = null

    private var privateDNSZone: Output<String>? = null

    /**
     * @param value IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     */
    @JvmName("ystwyhinetcqqyoi")
    public suspend fun authorizedIPRanges(`value`: Output<List<String>>) {
        this.authorizedIPRanges = value
    }

    @JvmName("aaswulwhukpssrtu")
    public suspend fun authorizedIPRanges(vararg values: Output<String>) {
        this.authorizedIPRanges = Output.all(values.asList())
    }

    /**
     * @param values IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     */
    @JvmName("tfmqbthymylyuctv")
    public suspend fun authorizedIPRanges(values: List<Output<String>>) {
        this.authorizedIPRanges = Output.all(values)
    }

    /**
     * @param value Whether to disable run command for the cluster or not.
     */
    @JvmName("bgiwfndmwpaetqgt")
    public suspend fun disableRunCommand(`value`: Output<Boolean>) {
        this.disableRunCommand = value
    }

    /**
     * @param value For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
     */
    @JvmName("psgdacrctkhcgyro")
    public suspend fun enablePrivateCluster(`value`: Output<Boolean>) {
        this.enablePrivateCluster = value
    }

    /**
     * @param value Whether to create additional public FQDN for private cluster or not.
     */
    @JvmName("npbdkpwnnvfbaijo")
    public suspend fun enablePrivateClusterPublicFQDN(`value`: Output<Boolean>) {
        this.enablePrivateClusterPublicFQDN = value
    }

    /**
     * @param value The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
     */
    @JvmName("ofswtycqaxvxakgi")
    public suspend fun privateDNSZone(`value`: Output<String>) {
        this.privateDNSZone = value
    }

    /**
     * @param value IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     */
    @JvmName("sjnxlriwveounliw")
    public suspend fun authorizedIPRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedIPRanges = mapped
    }

    /**
     * @param values IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     */
    @JvmName("gnfiklobnsqbabvv")
    public suspend fun authorizedIPRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizedIPRanges = mapped
    }

    /**
     * @param value Whether to disable run command for the cluster or not.
     */
    @JvmName("jiwwclxrxjmcgibx")
    public suspend fun disableRunCommand(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableRunCommand = mapped
    }

    /**
     * @param value For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
     */
    @JvmName("bmgphbgtnfrhyssd")
    public suspend fun enablePrivateCluster(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateCluster = mapped
    }

    /**
     * @param value Whether to create additional public FQDN for private cluster or not.
     */
    @JvmName("ljmuudsytmexlswl")
    public suspend fun enablePrivateClusterPublicFQDN(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateClusterPublicFQDN = mapped
    }

    /**
     * @param value The default is System. For more details see [configure private DNS zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are 'system' and 'none'.
     */
    @JvmName("hkwsigdesojfaqwa")
    public suspend fun privateDNSZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDNSZone = mapped
    }

    internal fun build(): ManagedClusterAPIServerAccessProfileArgs =
        ManagedClusterAPIServerAccessProfileArgs(
            authorizedIPRanges = authorizedIPRanges,
            disableRunCommand = disableRunCommand,
            enablePrivateCluster = enablePrivateCluster,
            enablePrivateClusterPublicFQDN = enablePrivateClusterPublicFQDN,
            privateDNSZone = privateDNSZone,
        )
}
