@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAddonProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Kubernetes add-on profile for a managed cluster.
 * @property config Key-value pairs for configuring an add-on.
 * @property enabled Whether the add-on is enabled or not.
 */
public data class ManagedClusterAddonProfileArgs(
    public val config: Output<Map<String, String>>? = null,
    public val enabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAddonProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAddonProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAddonProfileArgs.builder()
            .config(config?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterAddonProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterAddonProfileArgsBuilder internal constructor() {
    private var config: Output<Map<String, String>>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Key-value pairs for configuring an add-on.
     */
    @JvmName("rgrvwdpnaducpotu")
    public suspend fun config(`value`: Output<Map<String, String>>) {
        this.config = value
    }

    /**
     * @param value Whether the add-on is enabled or not.
     */
    @JvmName("glcdvkpybivddwkq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Key-value pairs for configuring an add-on.
     */
    @JvmName("bddqrwmpwnwxduwt")
    public suspend fun config(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param values Key-value pairs for configuring an add-on.
     */
    @JvmName("gutsbhtukkiirxuh")
    public fun config(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.config = mapped
    }

    /**
     * @param value Whether the add-on is enabled or not.
     */
    @JvmName("xkffairxkshgqnsl")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterAddonProfileArgs = ManagedClusterAddonProfileArgs(
        config = config,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
    )
}
