@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileMetricsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
 * @property enabled Whether to enable or disable the Azure Managed Prometheus addon for Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and disabling.
 * @property kubeStateMetrics Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
 */
public data class ManagedClusterAzureMonitorProfileMetricsArgs(
    public val enabled: Output<Boolean>,
    public val kubeStateMetrics: Output<ManagedClusterAzureMonitorProfileKubeStateMetricsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileMetricsArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileMetricsArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterAzureMonitorProfileMetricsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .kubeStateMetrics(
                kubeStateMetrics?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterAzureMonitorProfileMetricsArgs].
 */
@PulumiTagMarker
public class ManagedClusterAzureMonitorProfileMetricsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var kubeStateMetrics: Output<ManagedClusterAzureMonitorProfileKubeStateMetricsArgs>? =
        null

    /**
     * @param value Whether to enable or disable the Azure Managed Prometheus addon for Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and disabling.
     */
    @JvmName("agygcdhhbjvouths")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
     */
    @JvmName("vxfkxrqasswrflag")
    public suspend
    fun kubeStateMetrics(`value`: Output<ManagedClusterAzureMonitorProfileKubeStateMetricsArgs>) {
        this.kubeStateMetrics = value
    }

    /**
     * @param value Whether to enable or disable the Azure Managed Prometheus addon for Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and disabling.
     */
    @JvmName("rogxdtohxueiqefg")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
     */
    @JvmName("vmjtgvqmtgliwnwc")
    public suspend
    fun kubeStateMetrics(`value`: ManagedClusterAzureMonitorProfileKubeStateMetricsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubeStateMetrics = mapped
    }

    /**
     * @param argument Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
     */
    @JvmName("citulhyqwedebbyr")
    public suspend
    fun kubeStateMetrics(argument: suspend ManagedClusterAzureMonitorProfileKubeStateMetricsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAzureMonitorProfileKubeStateMetricsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kubeStateMetrics = mapped
    }

    internal fun build(): ManagedClusterAzureMonitorProfileMetricsArgs =
        ManagedClusterAzureMonitorProfileMetricsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            kubeStateMetrics = kubeStateMetrics,
        )
}
