@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Profile of the managed cluster load balancer.
 * @property allocatedOutboundPorts The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
 * @property effectiveOutboundIPs The effective outbound IP resources of the cluster load balancer.
 * @property enableMultipleStandardLoadBalancers Enable multiple standard load balancers per AKS cluster or not.
 * @property idleTimeoutInMinutes Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
 * @property managedOutboundIPs Desired managed outbound IPs for the cluster load balancer.
 * @property outboundIPPrefixes Desired outbound IP Prefix resources for the cluster load balancer.
 * @property outboundIPs Desired outbound IP resources for the cluster load balancer.
 */
public data class ManagedClusterLoadBalancerProfileArgs(
    public val allocatedOutboundPorts: Output<Int>? = null,
    public val effectiveOutboundIPs: Output<List<ResourceReferenceArgs>>? = null,
    public val enableMultipleStandardLoadBalancers: Output<Boolean>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val managedOutboundIPs: Output<ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs>? =
        null,
    public val outboundIPPrefixes: Output<ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs>? =
        null,
    public val outboundIPs: Output<ManagedClusterLoadBalancerProfileOutboundIPsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterLoadBalancerProfileArgs.builder()
            .allocatedOutboundPorts(allocatedOutboundPorts?.applyValue({ args0 -> args0 }))
            .effectiveOutboundIPs(
                effectiveOutboundIPs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableMultipleStandardLoadBalancers(
                enableMultipleStandardLoadBalancers?.applyValue({ args0 ->
                    args0
                }),
            )
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .managedOutboundIPs(
                managedOutboundIPs?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outboundIPPrefixes(
                outboundIPPrefixes?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outboundIPs(outboundIPs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedClusterLoadBalancerProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterLoadBalancerProfileArgsBuilder internal constructor() {
    private var allocatedOutboundPorts: Output<Int>? = null

    private var effectiveOutboundIPs: Output<List<ResourceReferenceArgs>>? = null

    private var enableMultipleStandardLoadBalancers: Output<Boolean>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var managedOutboundIPs: Output<ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs>? =
        null

    private var outboundIPPrefixes: Output<ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs>? =
        null

    private var outboundIPs: Output<ManagedClusterLoadBalancerProfileOutboundIPsArgs>? = null

    /**
     * @param value The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
     */
    @JvmName("vdvydibhlokhfcuc")
    public suspend fun allocatedOutboundPorts(`value`: Output<Int>) {
        this.allocatedOutboundPorts = value
    }

    /**
     * @param value The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("vcucijrhsrvpbkxa")
    public suspend fun effectiveOutboundIPs(`value`: Output<List<ResourceReferenceArgs>>) {
        this.effectiveOutboundIPs = value
    }

    @JvmName("tnpbepsihpmaxqwf")
    public suspend fun effectiveOutboundIPs(vararg values: Output<ResourceReferenceArgs>) {
        this.effectiveOutboundIPs = Output.all(values.asList())
    }

    /**
     * @param values The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("aeryqqeenfiyhnbw")
    public suspend fun effectiveOutboundIPs(values: List<Output<ResourceReferenceArgs>>) {
        this.effectiveOutboundIPs = Output.all(values)
    }

    /**
     * @param value Enable multiple standard load balancers per AKS cluster or not.
     */
    @JvmName("xondparnvhwbirae")
    public suspend fun enableMultipleStandardLoadBalancers(`value`: Output<Boolean>) {
        this.enableMultipleStandardLoadBalancers = value
    }

    /**
     * @param value Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
     */
    @JvmName("gqcbhbmmljvluhoc")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value Desired managed outbound IPs for the cluster load balancer.
     */
    @JvmName("tjumluphdlymffsw")
    public suspend
    fun managedOutboundIPs(`value`: Output<ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs>) {
        this.managedOutboundIPs = value
    }

    /**
     * @param value Desired outbound IP Prefix resources for the cluster load balancer.
     */
    @JvmName("hdlcorrabchlerbn")
    public suspend
    fun outboundIPPrefixes(`value`: Output<ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs>) {
        this.outboundIPPrefixes = value
    }

    /**
     * @param value Desired outbound IP resources for the cluster load balancer.
     */
    @JvmName("nyggucejlndxvgun")
    public suspend
    fun outboundIPs(`value`: Output<ManagedClusterLoadBalancerProfileOutboundIPsArgs>) {
        this.outboundIPs = value
    }

    /**
     * @param value The desired number of allocated SNAT ports per VM. Allowed values are in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure dynamically allocating ports.
     */
    @JvmName("anfihrfymsnwhwjh")
    public suspend fun allocatedOutboundPorts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocatedOutboundPorts = mapped
    }

    /**
     * @param value The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("vgichcvxwwpknmug")
    public suspend fun effectiveOutboundIPs(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("sxhpslwiplmvxfaf")
    public suspend
    fun effectiveOutboundIPs(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("nfwphppiofoomivq")
    public suspend fun effectiveOutboundIPs(
        vararg
        argument: suspend ResourceReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param argument The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("wsbuxrpmvjqqcydr")
    public suspend
    fun effectiveOutboundIPs(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param values The effective outbound IP resources of the cluster load balancer.
     */
    @JvmName("wwaajxxqjpjwmqkq")
    public suspend fun effectiveOutboundIPs(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effectiveOutboundIPs = mapped
    }

    /**
     * @param value Enable multiple standard load balancers per AKS cluster or not.
     */
    @JvmName("ggmitdaolkijpoct")
    public suspend fun enableMultipleStandardLoadBalancers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMultipleStandardLoadBalancers = mapped
    }

    /**
     * @param value Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 30 minutes.
     */
    @JvmName("xjfqitocnicohfdl")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value Desired managed outbound IPs for the cluster load balancer.
     */
    @JvmName("lcdvsnguvvdwcfcu")
    public suspend
    fun managedOutboundIPs(`value`: ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedOutboundIPs = mapped
    }

    /**
     * @param argument Desired managed outbound IPs for the cluster load balancer.
     */
    @JvmName("kwrylocjnqikuxfg")
    public suspend
    fun managedOutboundIPs(argument: suspend ManagedClusterLoadBalancerProfileManagedOutboundIPsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterLoadBalancerProfileManagedOutboundIPsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedOutboundIPs = mapped
    }

    /**
     * @param value Desired outbound IP Prefix resources for the cluster load balancer.
     */
    @JvmName("iytpxdmwxautdpwf")
    public suspend
    fun outboundIPPrefixes(`value`: ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundIPPrefixes = mapped
    }

    /**
     * @param argument Desired outbound IP Prefix resources for the cluster load balancer.
     */
    @JvmName("qfitqdssdrubwvqf")
    public suspend
    fun outboundIPPrefixes(argument: suspend ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterLoadBalancerProfileOutboundIPPrefixesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outboundIPPrefixes = mapped
    }

    /**
     * @param value Desired outbound IP resources for the cluster load balancer.
     */
    @JvmName("xeajjpkcgtpllfvh")
    public suspend fun outboundIPs(`value`: ManagedClusterLoadBalancerProfileOutboundIPsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundIPs = mapped
    }

    /**
     * @param argument Desired outbound IP resources for the cluster load balancer.
     */
    @JvmName("iayxkmsmxjqhtgvr")
    public suspend
    fun outboundIPs(argument: suspend ManagedClusterLoadBalancerProfileOutboundIPsArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterLoadBalancerProfileOutboundIPsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outboundIPs = mapped
    }

    internal fun build(): ManagedClusterLoadBalancerProfileArgs =
        ManagedClusterLoadBalancerProfileArgs(
            allocatedOutboundPorts = allocatedOutboundPorts,
            effectiveOutboundIPs = effectiveOutboundIPs,
            enableMultipleStandardLoadBalancers = enableMultipleStandardLoadBalancers,
            idleTimeoutInMinutes = idleTimeoutInMinutes,
            managedOutboundIPs = managedOutboundIPs,
            outboundIPPrefixes = outboundIPPrefixes,
            outboundIPs = outboundIPs,
        )
}
