@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterManagedOutboundIPProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Profile of the managed outbound IP resources of the managed cluster.
 * @property count The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
 */
public data class ManagedClusterManagedOutboundIPProfileArgs(
    public val count: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterManagedOutboundIPProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterManagedOutboundIPProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterManagedOutboundIPProfileArgs.builder()
            .count(count?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterManagedOutboundIPProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterManagedOutboundIPProfileArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    /**
     * @param value The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
     */
    @JvmName("ramewvfuexbmymaj")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16 (inclusive). The default value is 1.
     */
    @JvmName("eivmptmkgcijtwvi")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    internal fun build(): ManagedClusterManagedOutboundIPProfileArgs =
        ManagedClusterManagedOutboundIPProfileArgs(
            count = count,
        )
}
