@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterOIDCIssuerProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The OIDC issuer profile of the Managed Cluster.
 * @property enabled Whether the OIDC issuer is enabled.
 */
public data class ManagedClusterOIDCIssuerProfileArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterOIDCIssuerProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterOIDCIssuerProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterOIDCIssuerProfileArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterOIDCIssuerProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterOIDCIssuerProfileArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether the OIDC issuer is enabled.
     */
    @JvmName("uorqcujvjkpgoves")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether the OIDC issuer is enabled.
     */
    @JvmName("kwobnaeutsoibrya")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterOIDCIssuerProfileArgs = ManagedClusterOIDCIssuerProfileArgs(
        enabled = enabled,
    )
}
