@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.ManagedClusterSKUName
import com.pulumi.azurenative.containerservice.kotlin.enums.ManagedClusterSKUTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU of a Managed Cluster.
 * @property name The name of a managed cluster SKU.
 * @property tier If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
 */
public data class ManagedClusterSKUArgs(
    public val name: Output<Either<String, ManagedClusterSKUName>>? = null,
    public val tier: Output<Either<String, ManagedClusterSKUTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterSKUArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterSKUArgs].
 */
@PulumiTagMarker
public class ManagedClusterSKUArgsBuilder internal constructor() {
    private var name: Output<Either<String, ManagedClusterSKUName>>? = null

    private var tier: Output<Either<String, ManagedClusterSKUTier>>? = null

    /**
     * @param value The name of a managed cluster SKU.
     */
    @JvmName("tulwtxlcmhgsmmfs")
    public suspend fun name(`value`: Output<Either<String, ManagedClusterSKUName>>) {
        this.name = value
    }

    /**
     * @param value If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     */
    @JvmName("wqrrweoorgsmeuae")
    public suspend fun tier(`value`: Output<Either<String, ManagedClusterSKUTier>>) {
        this.tier = value
    }

    /**
     * @param value The name of a managed cluster SKU.
     */
    @JvmName("rytrnfcokmvdbukp")
    public suspend fun name(`value`: Either<String, ManagedClusterSKUName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of a managed cluster SKU.
     */
    @JvmName("utsyscsrkpasfqhg")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedClusterSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of a managed cluster SKU.
     */
    @JvmName("pnvutbsqqnbttvaq")
    public fun name(`value`: ManagedClusterSKUName) {
        val toBeMapped = Either.ofRight<String, ManagedClusterSKUName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     */
    @JvmName("hdrtgcbkuhhydsyg")
    public suspend fun tier(`value`: Either<String, ManagedClusterSKUTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     */
    @JvmName("chvchoutmnrarsyp")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedClusterSKUTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value If not specified, the default is 'Free'. See [AKS Pricing Tier](https://learn.microsoft.com/azure/aks/free-standard-pricing-tiers) for more details.
     */
    @JvmName("sgxdyckgpighdhok")
    public fun tier(`value`: ManagedClusterSKUTier) {
        val toBeMapped = Either.ofRight<String, ManagedClusterSKUTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ManagedClusterSKUArgs = ManagedClusterSKUArgs(
        name = name,
        tier = tier,
    )
}
