@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileSnapshotControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Snapshot Controller settings for the storage profile.
 * @property enabled Whether to enable Snapshot Controller. The default value is true.
 */
public data class ManagedClusterStorageProfileSnapshotControllerArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileSnapshotControllerArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileSnapshotControllerArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterStorageProfileSnapshotControllerArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterStorageProfileSnapshotControllerArgs].
 */
@PulumiTagMarker
public class ManagedClusterStorageProfileSnapshotControllerArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable Snapshot Controller. The default value is true.
     */
    @JvmName("igmvouemvtiqokoe")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable Snapshot Controller. The default value is true.
     */
    @JvmName("irjrcbiaprkwtiuf")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ManagedClusterStorageProfileSnapshotControllerArgs =
        ManagedClusterStorageProfileSnapshotControllerArgs(
            enabled = enabled,
        )
}
