@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.LicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Profile for Windows VMs in the managed cluster.
 * @property adminPassword Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
 * @property adminUsername Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
 * @property enableCSIProxy For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
 * @property gmsaProfile The Windows gMSA Profile in the Managed Cluster.
 * @property licenseType The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
 */
public data class ManagedClusterWindowsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>,
    public val enableCSIProxy: Output<Boolean>? = null,
    public val gmsaProfile: Output<WindowsGmsaProfileArgs>? = null,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterWindowsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername.applyValue({ args0 -> args0 }))
            .enableCSIProxy(enableCSIProxy?.applyValue({ args0 -> args0 }))
            .gmsaProfile(gmsaProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterWindowsProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterWindowsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var enableCSIProxy: Output<Boolean>? = null

    private var gmsaProfile: Output<WindowsGmsaProfileArgs>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
     */
    @JvmName("ehsixpgwljhrfjwy")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
     */
    @JvmName("iftsaybkxakbuwtv")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
     */
    @JvmName("vlpwtsoxvbgatxva")
    public suspend fun enableCSIProxy(`value`: Output<Boolean>) {
        this.enableCSIProxy = value
    }

    /**
     * @param value The Windows gMSA Profile in the Managed Cluster.
     */
    @JvmName("qpioihennksohoci")
    public suspend fun gmsaProfile(`value`: Output<WindowsGmsaProfileArgs>) {
        this.gmsaProfile = value
    }

    /**
     * @param value The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
     */
    @JvmName("rojidlkdodvlfcxu")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Specifies the password of the administrator account. <br><br> **Minimum-length:** 8 characters <br><br> **Max-length:** 123 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!"
     */
    @JvmName("eruuxufjjkrqjpif")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value Specifies the name of the administrator account. <br><br> **Restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length:** 1 character <br><br> **Max-length:** 20 characters
     */
    @JvmName("dpcixhxlfwxdndbi")
    public suspend fun adminUsername(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value For more details on CSI proxy, see the [CSI proxy GitHub repo](https://github.com/kubernetes-csi/csi-proxy).
     */
    @JvmName("tddhiawhstrlfwqi")
    public suspend fun enableCSIProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCSIProxy = mapped
    }

    /**
     * @param value The Windows gMSA Profile in the Managed Cluster.
     */
    @JvmName("gjaxcrlhaoxxetrc")
    public suspend fun gmsaProfile(`value`: WindowsGmsaProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaProfile = mapped
    }

    /**
     * @param argument The Windows gMSA Profile in the Managed Cluster.
     */
    @JvmName("pumbgihioeunkgvn")
    public suspend fun gmsaProfile(argument: suspend WindowsGmsaProfileArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsGmsaProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gmsaProfile = mapped
    }

    /**
     * @param value The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
     */
    @JvmName("wpfkbhfklmghakdh")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
     */
    @JvmName("nqddqtvcwqgsgntb")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type to use for Windows VMs. See [Azure Hybrid User Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
     */
    @JvmName("adleobihkwqjrtum")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    internal fun build(): ManagedClusterWindowsProfileArgs = ManagedClusterWindowsProfileArgs(
        adminPassword = adminPassword,
        adminUsername = adminUsername ?: throw PulumiNullFieldException("adminUsername"),
        enableCSIProxy = enableCSIProxy,
        gmsaProfile = gmsaProfile,
        licenseType = licenseType,
    )
}
