@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Workload Auto-scaler profile for the managed cluster.
 * @property keda KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
 */
public data class ManagedClusterWorkloadAutoScalerProfileArgs(
    public val keda: Output<ManagedClusterWorkloadAutoScalerProfileKedaArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.ManagedClusterWorkloadAutoScalerProfileArgs.builder()
            .keda(keda?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagedClusterWorkloadAutoScalerProfileArgs].
 */
@PulumiTagMarker
public class ManagedClusterWorkloadAutoScalerProfileArgsBuilder internal constructor() {
    private var keda: Output<ManagedClusterWorkloadAutoScalerProfileKedaArgs>? = null

    /**
     * @param value KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     */
    @JvmName("scyqpourgloqmuwm")
    public suspend fun keda(`value`: Output<ManagedClusterWorkloadAutoScalerProfileKedaArgs>) {
        this.keda = value
    }

    /**
     * @param value KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     */
    @JvmName("mqklhomyodcrnhlb")
    public suspend fun keda(`value`: ManagedClusterWorkloadAutoScalerProfileKedaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keda = mapped
    }

    /**
     * @param argument KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile.
     */
    @JvmName("pdhutddhkuqffyao")
    public suspend
    fun keda(argument: suspend ManagedClusterWorkloadAutoScalerProfileKedaArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterWorkloadAutoScalerProfileKedaArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keda = mapped
    }

    internal fun build(): ManagedClusterWorkloadAutoScalerProfileArgs =
        ManagedClusterWorkloadAutoScalerProfileArgs(
            keda = keda,
        )
}
