@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMasterPoolProfileArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.OpenShiftContainerServiceVMSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * OpenShiftManagedClusterMaterPoolProfile contains configuration for OpenShift master VMs.
 * @property apiProperties Defines further properties on the API.
 * @property count Number of masters (VMs) to host docker containers. The default value is 3.
 * @property subnetCidr Subnet CIDR for the peering.
 * @property vmSize Size of agent VMs.
 */
public data class OpenShiftManagedClusterMasterPoolProfileArgs(
    public val apiProperties: Output<OpenShiftAPIPropertiesArgs>? = null,
    public val count: Output<Int>,
    public val subnetCidr: Output<String>? = null,
    public val vmSize: Output<Either<String, OpenShiftContainerServiceVMSize>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMasterPoolProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMasterPoolProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.OpenShiftManagedClusterMasterPoolProfileArgs.builder()
            .apiProperties(apiProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .count(count.applyValue({ args0 -> args0 }))
            .subnetCidr(subnetCidr?.applyValue({ args0 -> args0 }))
            .vmSize(
                vmSize.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenShiftManagedClusterMasterPoolProfileArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterMasterPoolProfileArgsBuilder internal constructor() {
    private var apiProperties: Output<OpenShiftAPIPropertiesArgs>? = null

    private var count: Output<Int>? = null

    private var subnetCidr: Output<String>? = null

    private var vmSize: Output<Either<String, OpenShiftContainerServiceVMSize>>? = null

    /**
     * @param value Defines further properties on the API.
     */
    @JvmName("jsifkjrfqunmhejs")
    public suspend fun apiProperties(`value`: Output<OpenShiftAPIPropertiesArgs>) {
        this.apiProperties = value
    }

    /**
     * @param value Number of masters (VMs) to host docker containers. The default value is 3.
     */
    @JvmName("vcuyddnjjhxjgsur")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Subnet CIDR for the peering.
     */
    @JvmName("jyncexvtcpcsoinc")
    public suspend fun subnetCidr(`value`: Output<String>) {
        this.subnetCidr = value
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("ovwfjkgqrfntwvnw")
    public suspend fun vmSize(`value`: Output<Either<String, OpenShiftContainerServiceVMSize>>) {
        this.vmSize = value
    }

    /**
     * @param value Defines further properties on the API.
     */
    @JvmName("ikjgirqhnldvfsra")
    public suspend fun apiProperties(`value`: OpenShiftAPIPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiProperties = mapped
    }

    /**
     * @param argument Defines further properties on the API.
     */
    @JvmName("jxkcdcylsgqlnuax")
    public suspend fun apiProperties(argument: suspend OpenShiftAPIPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OpenShiftAPIPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiProperties = mapped
    }

    /**
     * @param value Number of masters (VMs) to host docker containers. The default value is 3.
     */
    @JvmName("atwcnxexnglutxwn")
    public suspend fun count(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Subnet CIDR for the peering.
     */
    @JvmName("qnqegjelcvffsakx")
    public suspend fun subnetCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetCidr = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("maqxyvolphtvuawm")
    public suspend fun vmSize(`value`: Either<String, OpenShiftContainerServiceVMSize>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("cdmuddukxtsipgbm")
    public fun vmSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OpenShiftContainerServiceVMSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Size of agent VMs.
     */
    @JvmName("jexemjkvgpmoiils")
    public fun vmSize(`value`: OpenShiftContainerServiceVMSize) {
        val toBeMapped = Either.ofRight<String, OpenShiftContainerServiceVMSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): OpenShiftManagedClusterMasterPoolProfileArgs =
        OpenShiftManagedClusterMasterPoolProfileArgs(
            apiProperties = apiProperties,
            count = count ?: throw PulumiNullFieldException("count"),
            subnetCidr = subnetCidr,
            vmSize = vmSize ?: throw PulumiNullFieldException("vmSize"),
        )
}
