@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.UpdateStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a stage which contains the groups to update and the steps to take (e.g., wait for a time period) before starting the next stage.
 * @property afterStageWaitInSeconds The time in seconds to wait at the end of this stage before starting the next one. Defaults to 0 seconds if unspecified.
 * @property groups Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
 * @property name The name of the stage. Must be unique within the UpdateRun.
 */
public data class UpdateStageArgs(
    public val afterStageWaitInSeconds: Output<Int>? = null,
    public val groups: Output<List<UpdateGroupArgs>>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.UpdateStageArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.UpdateStageArgs =
        com.pulumi.azurenative.containerservice.inputs.UpdateStageArgs.builder()
            .afterStageWaitInSeconds(afterStageWaitInSeconds?.applyValue({ args0 -> args0 }))
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdateStageArgs].
 */
@PulumiTagMarker
public class UpdateStageArgsBuilder internal constructor() {
    private var afterStageWaitInSeconds: Output<Int>? = null

    private var groups: Output<List<UpdateGroupArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The time in seconds to wait at the end of this stage before starting the next one. Defaults to 0 seconds if unspecified.
     */
    @JvmName("pqnevennfymwwexg")
    public suspend fun afterStageWaitInSeconds(`value`: Output<Int>) {
        this.afterStageWaitInSeconds = value
    }

    /**
     * @param value Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("svffcgkeobsnjsqt")
    public suspend fun groups(`value`: Output<List<UpdateGroupArgs>>) {
        this.groups = value
    }

    @JvmName("uxwoudkemkuyaidu")
    public suspend fun groups(vararg values: Output<UpdateGroupArgs>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("xykaklmmfcdacfle")
    public suspend fun groups(values: List<Output<UpdateGroupArgs>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The name of the stage. Must be unique within the UpdateRun.
     */
    @JvmName("ynxjvrtpdlqpvqbp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The time in seconds to wait at the end of this stage before starting the next one. Defaults to 0 seconds if unspecified.
     */
    @JvmName("ojsqiaowjsfmoksr")
    public suspend fun afterStageWaitInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afterStageWaitInSeconds = mapped
    }

    /**
     * @param value Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("ywldhrfmbtxjrsat")
    public suspend fun groups(`value`: List<UpdateGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param argument Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("warnvvyemtlhwyse")
    public suspend fun groups(argument: List<suspend UpdateGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { UpdateGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("veltpfbifamdiitt")
    public suspend fun groups(vararg argument: suspend UpdateGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { UpdateGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("lhladicpagbbtovw")
    public suspend fun groups(argument: suspend UpdateGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UpdateGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param values Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
     */
    @JvmName("jxiivqnramclksvs")
    public suspend fun groups(vararg values: UpdateGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The name of the stage. Must be unique within the UpdateRun.
     */
    @JvmName("vgkdcvonspduqequ")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): UpdateStageArgs = UpdateStageArgs(
        afterStageWaitInSeconds = afterStageWaitInSeconds,
        groups = groups,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
