@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.inputs

import com.pulumi.azurenative.containerservice.inputs.WindowsGmsaProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Windows gMSA Profile in the managed cluster.
 * @property dnsServer Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
 * @property enabled Specifies whether to enable Windows gMSA in the managed cluster.
 * @property rootDomainName Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
 */
public data class WindowsGmsaProfileArgs(
    public val dnsServer: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val rootDomainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.inputs.WindowsGmsaProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.inputs.WindowsGmsaProfileArgs =
        com.pulumi.azurenative.containerservice.inputs.WindowsGmsaProfileArgs.builder()
            .dnsServer(dnsServer?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .rootDomainName(rootDomainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsGmsaProfileArgs].
 */
@PulumiTagMarker
public class WindowsGmsaProfileArgsBuilder internal constructor() {
    private var dnsServer: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var rootDomainName: Output<String>? = null

    /**
     * @param value Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     */
    @JvmName("wckwtidsxknjqiws")
    public suspend fun dnsServer(`value`: Output<String>) {
        this.dnsServer = value
    }

    /**
     * @param value Specifies whether to enable Windows gMSA in the managed cluster.
     */
    @JvmName("rnqapfniklftvahv")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     */
    @JvmName("jppnxrsuughpeejr")
    public suspend fun rootDomainName(`value`: Output<String>) {
        this.rootDomainName = value
    }

    /**
     * @param value Specifies the DNS server for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     */
    @JvmName("lknepwwaspghepju")
    public suspend fun dnsServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServer = mapped
    }

    /**
     * @param value Specifies whether to enable Windows gMSA in the managed cluster.
     */
    @JvmName("cqmkklwjdqeynkbc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the root domain name for Windows gMSA. <br><br> Set it to empty if you have configured the DNS server in the vnet which is used to create the managed cluster.
     */
    @JvmName("eoikwedddunirhhg")
    public suspend fun rootDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDomainName = mapped
    }

    internal fun build(): WindowsGmsaProfileArgs = WindowsGmsaProfileArgs(
        dnsServer = dnsServer,
        enabled = enabled,
        rootDomainName = rootDomainName,
    )
}
