@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
 * @property allowedUnsafeSysctls Allowed list of unsafe sysctls or unsafe sysctl patterns (ending in `*`).
 * @property containerLogMaxFiles The maximum number of container log files that can be present for a container. The number must be ≥ 2.
 * @property containerLogMaxSizeMB The maximum size (e.g. 10Mi) of container log file before it is rotated.
 * @property cpuCfsQuota The default is true.
 * @property cpuCfsQuotaPeriod The default is '100ms.' Valid values are a sequence of decimal numbers with an optional fraction and a unit suffix. For example: '300ms', '2h45m'. Supported units are 'ns', 'us', 'ms', 's', 'm', and 'h'.
 * @property cpuManagerPolicy The default is 'none'. See [Kubernetes CPU management policies](https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/#cpu-management-policies) for more information. Allowed values are 'none' and 'static'.
 * @property failSwapOn If set to true it will make the Kubelet fail to start if swap is enabled on the node.
 * @property imageGcHighThreshold To disable image garbage collection, set to 100. The default is 85%
 * @property imageGcLowThreshold This cannot be set higher than imageGcHighThreshold. The default is 80%
 * @property podMaxPids The maximum number of processes per pod.
 * @property topologyManagerPolicy For more information see [Kubernetes Topology Manager](https://kubernetes.io/docs/tasks/administer-cluster/topology-manager). The default is 'none'. Allowed values are 'none', 'best-effort', 'restricted', and 'single-numa-node'.
 */
public data class KubeletConfigResponse(
    public val allowedUnsafeSysctls: List<String>? = null,
    public val containerLogMaxFiles: Int? = null,
    public val containerLogMaxSizeMB: Int? = null,
    public val cpuCfsQuota: Boolean? = null,
    public val cpuCfsQuotaPeriod: String? = null,
    public val cpuManagerPolicy: String? = null,
    public val failSwapOn: Boolean? = null,
    public val imageGcHighThreshold: Int? = null,
    public val imageGcLowThreshold: Int? = null,
    public val podMaxPids: Int? = null,
    public val topologyManagerPolicy: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.KubeletConfigResponse):
            KubeletConfigResponse = KubeletConfigResponse(
            allowedUnsafeSysctls = javaType.allowedUnsafeSysctls().map({ args0 -> args0 }),
            containerLogMaxFiles = javaType.containerLogMaxFiles().map({ args0 -> args0 }).orElse(null),
            containerLogMaxSizeMB = javaType.containerLogMaxSizeMB().map({ args0 -> args0 }).orElse(null),
            cpuCfsQuota = javaType.cpuCfsQuota().map({ args0 -> args0 }).orElse(null),
            cpuCfsQuotaPeriod = javaType.cpuCfsQuotaPeriod().map({ args0 -> args0 }).orElse(null),
            cpuManagerPolicy = javaType.cpuManagerPolicy().map({ args0 -> args0 }).orElse(null),
            failSwapOn = javaType.failSwapOn().map({ args0 -> args0 }).orElse(null),
            imageGcHighThreshold = javaType.imageGcHighThreshold().map({ args0 -> args0 }).orElse(null),
            imageGcLowThreshold = javaType.imageGcLowThreshold().map({ args0 -> args0 }).orElse(null),
            podMaxPids = javaType.podMaxPids().map({ args0 -> args0 }).orElse(null),
            topologyManagerPolicy = javaType.topologyManagerPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
