@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Auto upgrade profile for a managed cluster.
 * @property upgradeChannel For more information see [setting the AKS cluster auto-upgrade channel](https://docs.microsoft.com/azure/aks/upgrade-cluster#set-auto-upgrade-channel).
 */
public data class ManagedClusterAutoUpgradeProfileResponse(
    public val upgradeChannel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAutoUpgradeProfileResponse):
            ManagedClusterAutoUpgradeProfileResponse = ManagedClusterAutoUpgradeProfileResponse(
            upgradeChannel = javaType.upgradeChannel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
