@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Metrics profile for the Azure Monitor managed service for Prometheus addon. Collect out-of-the-box Kubernetes infrastructure metrics to send to an Azure Monitor Workspace and configure additional scraping for custom targets. See aka.ms/AzureManagedPrometheus for an overview.
 * @property enabled Whether to enable or disable the Azure Managed Prometheus addon for Prometheus monitoring. See aka.ms/AzureManagedPrometheus-aks-enable for details on enabling and disabling.
 * @property kubeStateMetrics Kube State Metrics profile for the Azure Managed Prometheus addon. These optional settings are for the kube-state-metrics pod that is deployed with the addon. See aka.ms/AzureManagedPrometheus-optional-parameters for details.
 */
public data class ManagedClusterAzureMonitorProfileMetricsResponse(
    public val enabled: Boolean,
    public val kubeStateMetrics: ManagedClusterAzureMonitorProfileKubeStateMetricsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAzureMonitorProfileMetricsResponse):
            ManagedClusterAzureMonitorProfileMetricsResponse =
            ManagedClusterAzureMonitorProfileMetricsResponse(
                enabled = javaType.enabled(),
                kubeStateMetrics = javaType.kubeStateMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterAzureMonitorProfileKubeStateMetricsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
