@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 * See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on pod identity integration.
 * @property allowNetworkPluginKubenet Running in Kubenet is disabled by default due to the security related nature of AAD Pod Identity and the risks of IP spoofing. See [using Kubenet network plugin with AAD Pod Identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity#using-kubenet-network-plugin-with-azure-active-directory-pod-managed-identities) for more information.
 * @property enabled Whether the pod identity addon is enabled.
 * @property userAssignedIdentities The pod identities to use in the cluster.
 * @property userAssignedIdentityExceptions The pod identity exceptions to allow.
 */
public data class ManagedClusterPodIdentityProfileResponse(
    public val allowNetworkPluginKubenet: Boolean? = null,
    public val enabled: Boolean? = null,
    public val userAssignedIdentities: List<ManagedClusterPodIdentityResponse>? = null,
    public val userAssignedIdentityExceptions: List<ManagedClusterPodIdentityExceptionResponse>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterPodIdentityProfileResponse):
            ManagedClusterPodIdentityProfileResponse = ManagedClusterPodIdentityProfileResponse(
            allowNetworkPluginKubenet = javaType.allowNetworkPluginKubenet().map({ args0 ->
                args0
            }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityResponse.Companion.toKotlin(args0)
                })
            }),
            userAssignedIdentityExceptions = javaType.userAssignedIdentityExceptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterPodIdentityExceptionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
