@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Image Cleaner removes unused images from nodes, freeing up disk space and helping to reduce attack surface area. Here are settings for the security profile.
 * @property enabled Whether to enable Image Cleaner on AKS cluster.
 * @property intervalHours Image Cleaner scanning interval in hours.
 */
public data class ManagedClusterSecurityProfileImageCleanerResponse(
    public val enabled: Boolean? = null,
    public val intervalHours: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterSecurityProfileImageCleanerResponse):
            ManagedClusterSecurityProfileImageCleanerResponse =
            ManagedClusterSecurityProfileImageCleanerResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                intervalHours = javaType.intervalHours().map({ args0 -> args0 }).orElse(null),
            )
    }
}
