@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The upgrade to apply to a ManagedCluster.
 * @property kubernetesVersion The Kubernetes version to upgrade the member clusters to.
 * @property type The upgrade type.
 * Full requires the KubernetesVersion property to be set.
 * NodeImageOnly requires the KubernetesVersion property not to be set.
 */
public data class ManagedClusterUpgradeSpecResponse(
    public val kubernetesVersion: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterUpgradeSpecResponse):
            ManagedClusterUpgradeSpecResponse = ManagedClusterUpgradeSpecResponse(
            kubernetesVersion = javaType.kubernetesVersion().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
