@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the OpenShift networking configuration
 * @property managementSubnetCidr CIDR of subnet used to create PLS needed for management of the cluster
 * @property vnetCidr CIDR for the OpenShift Vnet.
 * @property vnetId ID of the Vnet created for OSA cluster.
 */
public data class NetworkProfileResponse(
    public val managementSubnetCidr: String? = null,
    public val vnetCidr: String? = null,
    public val vnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.NetworkProfileResponse):
            NetworkProfileResponse = NetworkProfileResponse(
            managementSubnetCidr = javaType.managementSubnetCidr().map({ args0 -> args0 }).orElse(null),
            vnetCidr = javaType.vnetCidr().map({ args0 -> args0 }).orElse(null),
            vnetId = javaType.vnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
