@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines all possible authentication profiles for the OpenShift cluster.
 * @property identityProviders Type of authentication profile to use.
 */
public data class OpenShiftManagedClusterAuthProfileResponse(
    public val identityProviders: List<OpenShiftManagedClusterIdentityProviderResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterAuthProfileResponse):
            OpenShiftManagedClusterAuthProfileResponse = OpenShiftManagedClusterAuthProfileResponse(
            identityProviders = javaType.identityProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterIdentityProviderResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
