@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * OpenShiftManagedClusterMaterPoolProfile contains configuration for OpenShift master VMs.
 * @property apiProperties Defines further properties on the API.
 * @property count Number of masters (VMs) to host docker containers. The default value is 3.
 * @property subnetCidr Subnet CIDR for the peering.
 * @property vmSize Size of agent VMs.
 */
public data class OpenShiftManagedClusterMasterPoolProfileResponse(
    public val apiProperties: OpenShiftAPIPropertiesResponse? = null,
    public val count: Int,
    public val subnetCidr: String? = null,
    public val vmSize: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.OpenShiftManagedClusterMasterPoolProfileResponse):
            OpenShiftManagedClusterMasterPoolProfileResponse =
            OpenShiftManagedClusterMasterPoolProfileResponse(
                apiProperties = javaType.apiProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftAPIPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                count = javaType.count(),
                subnetCidr = javaType.subnetCidr().map({ args0 -> args0 }).orElse(null),
                vmSize = javaType.vmSize(),
            )
    }
}
