@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A private link resource
 * @property groupId The group ID of the resource.
 * @property id The ID of the private link resource.
 * @property name The name of the private link resource.
 * @property privateLinkServiceID The private link service ID of the resource, this field is exposed only to NRP internally.
 * @property requiredMembers The RequiredMembers of the resource
 * @property type The resource type.
 */
public data class PrivateLinkResourceResponse(
    public val groupId: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val privateLinkServiceID: String,
    public val requiredMembers: List<String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.PrivateLinkResourceResponse):
            PrivateLinkResourceResponse = PrivateLinkResourceResponse(
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateLinkServiceID = javaType.privateLinkServiceID(),
            requiredMembers = javaType.requiredMembers().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
