@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.
 * @property name The plan ID.
 * @property product Specifies the product of the image from the marketplace. This is the same value as Offer under the imageReference element.
 * @property promotionCode The promotion code.
 * @property publisher The plan ID.
 */
public data class PurchasePlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.PurchasePlanResponse):
            PurchasePlanResponse = PurchasePlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
