@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Time in a week.
 * @property day The day of the week.
 * @property hourSlots Each integer hour represents a time range beginning at 0m after the hour ending at the next hour (non-inclusive). 0 corresponds to 00:00 UTC, 23 corresponds to 23:00 UTC. Specifying [0, 1] means the 00:00 - 02:00 UTC time range.
 */
public data class TimeInWeekResponse(
    public val day: String? = null,
    public val hourSlots: List<Int>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.TimeInWeekResponse):
            TimeInWeekResponse = TimeInWeekResponse(
            day = javaType.day().map({ args0 -> args0 }).orElse(null),
            hourSlots = javaType.hourSlots().map({ args0 -> args0 }),
        )
    }
}
