@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The status of a UpdateStage.
 * @property afterStageWaitStatus The status of the wait period configured on the UpdateStage.
 * @property groups The list of groups to be updated as part of this UpdateStage.
 * @property name The name of the UpdateStage.
 * @property status The status of the UpdateStage.
 */
public data class UpdateStageStatusResponse(
    public val afterStageWaitStatus: WaitStatusResponse,
    public val groups: List<UpdateGroupStatusResponse>,
    public val name: String,
    public val status: UpdateStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateStageStatusResponse):
            UpdateStageStatusResponse = UpdateStageStatusResponse(
            afterStageWaitStatus = javaType.afterStageWaitStatus().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.WaitStatusResponse.Companion.toKotlin(args0)
            }),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateGroupStatusResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
