@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.EncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption key properties for the pool.
 * @property identity The managed service identities assigned to this resource.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The URI of the key vault.
 */
public data class EncryptionArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.EncryptionArgs =
        com.pulumi.azurenative.containerstorage.inputs.EncryptionArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("ulyimbadisiwcaqd")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("qgdtgdkgxymllfjl")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The URI of the key vault.
     */
    @JvmName("gonhvghaaxngmgiv")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("rhijhacofnceamqv")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("efgotmcpfhxnibst")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("nseyawxgopxocmrd")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The URI of the key vault.
     */
    @JvmName("kmhydjiutwmwwyoq")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        identity = identity,
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
    )
}
