@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Pool Object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeName Volume Resource
 */
public data class GetVolumePlainArgs(
    public val poolName: String,
    public val resourceGroupName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.GetVolumePlainArgs =
        com.pulumi.azurenative.containerstorage.inputs.GetVolumePlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var resourceGroupName: String? = null

    private var volumeName: String? = null

    /**
     * @param value Pool Object
     */
    @JvmName("bxaurmesfnafnpsx")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xkaguuabypkbqjrn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Volume Resource
     */
    @JvmName("itqbcifsuttnuxfa")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
