@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Type of the Pool: ephemeralDisk, azureDisk, or elasticsan
 * @property azureDisk Disk Pool Properties
 * @property elasticSan Elastic San Pool Properties
 * @property ephemeralDisk Ephemeral Pool Properties
 */
public data class PoolTypeArgs(
    public val azureDisk: Output<AzureDiskArgs>? = null,
    public val elasticSan: Output<ElasticSanArgs>? = null,
    public val ephemeralDisk: Output<EphemeralDiskArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs =
        com.pulumi.azurenative.containerstorage.inputs.PoolTypeArgs.builder()
            .azureDisk(azureDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .elasticSan(elasticSan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ephemeralDisk(ephemeralDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PoolTypeArgs].
 */
@PulumiTagMarker
public class PoolTypeArgsBuilder internal constructor() {
    private var azureDisk: Output<AzureDiskArgs>? = null

    private var elasticSan: Output<ElasticSanArgs>? = null

    private var ephemeralDisk: Output<EphemeralDiskArgs>? = null

    /**
     * @param value Disk Pool Properties
     */
    @JvmName("xjnbjexauhlttsuk")
    public suspend fun azureDisk(`value`: Output<AzureDiskArgs>) {
        this.azureDisk = value
    }

    /**
     * @param value Elastic San Pool Properties
     */
    @JvmName("gtktxngwssqtopqw")
    public suspend fun elasticSan(`value`: Output<ElasticSanArgs>) {
        this.elasticSan = value
    }

    /**
     * @param value Ephemeral Pool Properties
     */
    @JvmName("rqbjqyvvcipcmoom")
    public suspend fun ephemeralDisk(`value`: Output<EphemeralDiskArgs>) {
        this.ephemeralDisk = value
    }

    /**
     * @param value Disk Pool Properties
     */
    @JvmName("epmmqpoicnlfavtm")
    public suspend fun azureDisk(`value`: AzureDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDisk = mapped
    }

    /**
     * @param argument Disk Pool Properties
     */
    @JvmName("rwwvpwuklwtxoslm")
    public suspend fun azureDisk(argument: suspend AzureDiskArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureDisk = mapped
    }

    /**
     * @param value Elastic San Pool Properties
     */
    @JvmName("pfemrocphpoavvkq")
    public suspend fun elasticSan(`value`: ElasticSanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSan = mapped
    }

    /**
     * @param argument Elastic San Pool Properties
     */
    @JvmName("bpylbemejfawuvhm")
    public suspend fun elasticSan(argument: suspend ElasticSanArgsBuilder.() -> Unit) {
        val toBeMapped = ElasticSanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.elasticSan = mapped
    }

    /**
     * @param value Ephemeral Pool Properties
     */
    @JvmName("igtxumjwihibymap")
    public suspend fun ephemeralDisk(`value`: EphemeralDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralDisk = mapped
    }

    /**
     * @param argument Ephemeral Pool Properties
     */
    @JvmName("ryqxjdmyqwvrugba")
    public suspend fun ephemeralDisk(argument: suspend EphemeralDiskArgsBuilder.() -> Unit) {
        val toBeMapped = EphemeralDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralDisk = mapped
    }

    internal fun build(): PoolTypeArgs = PoolTypeArgs(
        azureDisk = azureDisk,
        elasticSan = elasticSan,
        ephemeralDisk = ephemeralDisk,
    )
}
