@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Assignment Properties
 * @property id Resource id for the assigned resource
 * @property status Indicates if the assignment is in a usable state
 */
public data class AssignmentResponse(
    public val id: String,
    public val status: AssignmentStatusResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.AssignmentResponse):
            AssignmentResponse = AssignmentResponse(
            id = javaType.id(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerstorage.kotlin.outputs.AssignmentStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
