@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetFilterResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetTimePeriodResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.CurrentSpendResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ForecastSpendResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.NotificationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetFilterResponse.Companion.toKotlin as budgetFilterResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetTimePeriodResponse.Companion.toKotlin as budgetTimePeriodResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.CurrentSpendResponse.Companion.toKotlin as currentSpendResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ForecastSpendResponse.Companion.toKotlin as forecastSpendResponseToKotlin
import com.pulumi.azurenative.costmanagement.kotlin.outputs.NotificationResponse.Companion.toKotlin as notificationResponseToKotlin

/**
 * Builder for [Budget].
 */
@PulumiTagMarker
public class BudgetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetArgs = BudgetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetArgsBuilder.() -> Unit) {
        val builder = BudgetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Budget {
        val builtJavaResource = com.pulumi.azurenative.costmanagement.Budget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Budget(builtJavaResource)
    }
}

/**
 * A budget resource.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2019-04-01-preview, 2023-08-01.
 */
public class Budget internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.Budget,
) : KotlinCustomResource(javaResource, BudgetMapper) {
    /**
     * The total amount of cost to track with the budget.
     *  Supported for CategoryType(s): Cost.
     *  Required for CategoryType(s): Cost.
     */
    public val amount: Output<Double>?
        get() = javaResource.amount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The category of the budget.
     * - 'Cost' defines a Budget.
     * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The current amount of cost which is being tracked for a budget.
     *  Supported for CategoryType(s): Cost.
     */
    public val currentSpend: Output<CurrentSpendResponse>
        get() = javaResource.currentSpend().applyValue({ args0 ->
            args0.let({ args0 ->
                currentSpendResponseToKotlin(args0)
            })
        })

    /**
     * eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * May be used to filter budgets by user-specified dimensions and/or tags.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    public val filter: Output<BudgetFilterResponse>?
        get() = javaResource.filter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    budgetFilterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The forecasted cost which is being tracked for a budget.
     *  Supported for CategoryType(s): Cost.
     */
    public val forecastSpend: Output<ForecastSpendResponse>
        get() = javaResource.forecastSpend().applyValue({ args0 ->
            args0.let({ args0 ->
                forecastSpendResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dictionary of notifications associated with the budget.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
     * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
     */
    public val notifications: Output<Map<String, NotificationResponse>>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            notificationResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The time covered by a budget. Tracking of the amount will be reset based on the time grain.
     * Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported timeGrainTypes for **CategoryType: Cost**
     * - Monthly
     * - Quarterly
     * - Annually
     * - BillingMonth*
     * - BillingQuarter*
     * - BillingAnnual*
     *   *only supported for Web Direct customers.
     *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
     * - Last7Days
     * - Last30Days
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    public val timeGrain: Output<String>
        get() = javaResource.timeGrain().applyValue({ args0 -> args0 })

    /**
     * The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    public val timePeriod: Output<BudgetTimePeriodResponse>
        get() = javaResource.timePeriod().applyValue({ args0 ->
            args0.let({ args0 ->
                budgetTimePeriodResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BudgetMapper : ResourceMapper<Budget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.Budget::class == javaResource::class

    override fun map(javaResource: Resource): Budget = Budget(
        javaResource as
            com.pulumi.azurenative.costmanagement.Budget,
    )
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Budget].
 */
public suspend fun budget(name: String, block: suspend BudgetResourceBuilder.() -> Unit): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Budget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budget(name: String): Budget {
    val builder = BudgetResourceBuilder()
    builder.name(name)
    return builder.build()
}
