@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.BudgetArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.CategoryType
import com.pulumi.azurenative.costmanagement.kotlin.enums.TimeGrainType
import com.pulumi.azurenative.costmanagement.kotlin.inputs.BudgetFilterArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.BudgetFilterArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.BudgetTimePeriodArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.BudgetTimePeriodArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.NotificationArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.NotificationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A budget resource.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2019-04-01-preview, 2023-08-01.
 * @property amount The total amount of cost to track with the budget.
 *  Supported for CategoryType(s): Cost.
 *  Required for CategoryType(s): Cost.
 * @property budgetName Budget Name.
 * @property category The category of the budget.
 * - 'Cost' defines a Budget.
 * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
 * @property eTag eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
 * @property filter May be used to filter budgets by user-specified dimensions and/or tags.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property notifications Dictionary of notifications associated with the budget.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
 * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
 * @property scope The scope associated with budget operations.
 *  Supported scopes for **CategoryType: Cost**
 *  Azure RBAC Scopes:
 * - '/subscriptions/{subscriptionId}/' for subscription scope
 * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
 * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
 *  EA (Enterprise Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
 *  MCA (Modern Customer Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
 *  Supported scopes for **CategoryType: ReservationUtilization**
 *  EA (Enterprise Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
 * MCA (Modern Customer Agreement) Scopes:
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
 * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
 * @property timeGrain The time covered by a budget. Tracking of the amount will be reset based on the time grain.
 * Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Supported timeGrainTypes for **CategoryType: Cost**
 * - Monthly
 * - Quarterly
 * - Annually
 * - BillingMonth*
 * - BillingQuarter*
 * - BillingAnnual*
 *   *only supported for Web Direct customers.
 *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
 * - Last7Days
 * - Last30Days
 *  Required for CategoryType(s): Cost, ReservationUtilization.
 * @property timePeriod The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Required for CategoryType(s): Cost, ReservationUtilization.
 */
public data class BudgetArgs(
    public val amount: Output<Double>? = null,
    public val budgetName: Output<String>? = null,
    public val category: Output<Either<String, CategoryType>>? = null,
    public val eTag: Output<String>? = null,
    public val filter: Output<BudgetFilterArgs>? = null,
    public val notifications: Output<Map<String, NotificationArgs>>? = null,
    public val scope: Output<String>? = null,
    public val timeGrain: Output<Either<String, TimeGrainType>>? = null,
    public val timePeriod: Output<BudgetTimePeriodArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.BudgetArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.BudgetArgs =
        com.pulumi.azurenative.costmanagement.BudgetArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .budgetName(budgetName?.applyValue({ args0 -> args0 }))
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notifications(
                notifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .timeGrain(
                timeGrain?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timePeriod(timePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BudgetArgs].
 */
@PulumiTagMarker
public class BudgetArgsBuilder internal constructor() {
    private var amount: Output<Double>? = null

    private var budgetName: Output<String>? = null

    private var category: Output<Either<String, CategoryType>>? = null

    private var eTag: Output<String>? = null

    private var filter: Output<BudgetFilterArgs>? = null

    private var notifications: Output<Map<String, NotificationArgs>>? = null

    private var scope: Output<String>? = null

    private var timeGrain: Output<Either<String, TimeGrainType>>? = null

    private var timePeriod: Output<BudgetTimePeriodArgs>? = null

    /**
     * @param value The total amount of cost to track with the budget.
     *  Supported for CategoryType(s): Cost.
     *  Required for CategoryType(s): Cost.
     */
    @JvmName("pthlbssgrkxxycdy")
    public suspend fun amount(`value`: Output<Double>) {
        this.amount = value
    }

    /**
     * @param value Budget Name.
     */
    @JvmName("ufrfjjvvwcbfakeg")
    public suspend fun budgetName(`value`: Output<String>) {
        this.budgetName = value
    }

    /**
     * @param value The category of the budget.
     * - 'Cost' defines a Budget.
     * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
     */
    @JvmName("pcpegryjawuijrea")
    public suspend fun category(`value`: Output<Either<String, CategoryType>>) {
        this.category = value
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("qqwerordjjrwvttl")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value May be used to filter budgets by user-specified dimensions and/or tags.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("yixwdsdyexialmup")
    public suspend fun filter(`value`: Output<BudgetFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value Dictionary of notifications associated with the budget.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
     * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
     */
    @JvmName("drgpruuoonmxqpft")
    public suspend fun notifications(`value`: Output<Map<String, NotificationArgs>>) {
        this.notifications = value
    }

    /**
     * @param value The scope associated with budget operations.
     *  Supported scopes for **CategoryType: Cost**
     *  Azure RBAC Scopes:
     * - '/subscriptions/{subscriptionId}/' for subscription scope
     * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
     * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
     *  MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     *  Supported scopes for **CategoryType: ReservationUtilization**
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
     * MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     */
    @JvmName("igpwpxarimwvtpek")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain.
     * Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported timeGrainTypes for **CategoryType: Cost**
     * - Monthly
     * - Quarterly
     * - Annually
     * - BillingMonth*
     * - BillingQuarter*
     * - BillingAnnual*
     *   *only supported for Web Direct customers.
     *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
     * - Last7Days
     * - Last30Days
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("puovadulptmlqpty")
    public suspend fun timeGrain(`value`: Output<Either<String, TimeGrainType>>) {
        this.timeGrain = value
    }

    /**
     * @param value The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("lmaxttgswfuyekmo")
    public suspend fun timePeriod(`value`: Output<BudgetTimePeriodArgs>) {
        this.timePeriod = value
    }

    /**
     * @param value The total amount of cost to track with the budget.
     *  Supported for CategoryType(s): Cost.
     *  Required for CategoryType(s): Cost.
     */
    @JvmName("rashktretoechadu")
    public suspend fun amount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value Budget Name.
     */
    @JvmName("fnhtfwoyhtbgwaxd")
    public suspend fun budgetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetName = mapped
    }

    /**
     * @param value The category of the budget.
     * - 'Cost' defines a Budget.
     * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
     */
    @JvmName("wqwhohlpsemgoaax")
    public suspend fun category(`value`: Either<String, CategoryType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The category of the budget.
     * - 'Cost' defines a Budget.
     * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
     */
    @JvmName("twouuyuisjeqhnuo")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CategoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The category of the budget.
     * - 'Cost' defines a Budget.
     * - 'ReservationUtilization' defines a Reservation Utilization Alert Rule.
     */
    @JvmName("ebaxepjvjxgweotd")
    public fun category(`value`: CategoryType) {
        val toBeMapped = Either.ofRight<String, CategoryType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not.
     */
    @JvmName("rdcjotdrpcpymrmx")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value May be used to filter budgets by user-specified dimensions and/or tags.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("loqwumwhpfdafbay")
    public suspend fun filter(`value`: BudgetFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument May be used to filter budgets by user-specified dimensions and/or tags.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("guakeamyxdvgorno")
    public suspend fun filter(argument: suspend BudgetFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Dictionary of notifications associated with the budget.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
     * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
     */
    @JvmName("cupdyhjfuurxvdpw")
    public suspend fun notifications(`value`: Map<String, NotificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param argument Dictionary of notifications associated with the budget.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
     * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
     */
    @JvmName("tihhhfidcnntktmf")
    public suspend fun notifications(
        vararg
        argument: Pair<String, suspend NotificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                NotificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.notifications = mapped
    }

    /**
     * @param values Dictionary of notifications associated with the budget.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     * - Constraints for **CategoryType: Cost** - Budget can have up to 5 notifications with thresholdType: Actual and 5 notifications with thresholdType: Forecasted.
     * - Constraints for **CategoryType: ReservationUtilization** - Only one notification allowed. thresholdType is not applicable.
     */
    @JvmName("begdwfsscrpowsda")
    public fun notifications(vararg values: Pair<String, NotificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value The scope associated with budget operations.
     *  Supported scopes for **CategoryType: Cost**
     *  Azure RBAC Scopes:
     * - '/subscriptions/{subscriptionId}/' for subscription scope
     * - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope
     * - '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope
     *  MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     *  Supported scopes for **CategoryType: ReservationUtilization**
     *  EA (Enterprise Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account Scope
     * MCA (Modern Customer Agreement) Scopes:
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope (non-CSP only)
     * - '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/customers/{customerId}' for customer scope (CSP only)
     */
    @JvmName("wdjgqotvspxhrdkq")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain.
     * Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported timeGrainTypes for **CategoryType: Cost**
     * - Monthly
     * - Quarterly
     * - Annually
     * - BillingMonth*
     * - BillingQuarter*
     * - BillingAnnual*
     *   *only supported for Web Direct customers.
     *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
     * - Last7Days
     * - Last30Days
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("cdxtupbweodgwmbw")
    public suspend fun timeGrain(`value`: Either<String, TimeGrainType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain.
     * Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported timeGrainTypes for **CategoryType: Cost**
     * - Monthly
     * - Quarterly
     * - Annually
     * - BillingMonth*
     * - BillingQuarter*
     * - BillingAnnual*
     *   *only supported for Web Direct customers.
     *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
     * - Last7Days
     * - Last30Days
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("gwsuejjdwvvmvvmi")
    public fun timeGrain(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeGrainType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value The time covered by a budget. Tracking of the amount will be reset based on the time grain.
     * Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported timeGrainTypes for **CategoryType: Cost**
     * - Monthly
     * - Quarterly
     * - Annually
     * - BillingMonth*
     * - BillingQuarter*
     * - BillingAnnual*
     *   *only supported for Web Direct customers.
     *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
     * - Last7Days
     * - Last30Days
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("mbshucplyuixavyw")
    public fun timeGrain(`value`: TimeGrainType) {
        val toBeMapped = Either.ofRight<String, TimeGrainType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeGrain = mapped
    }

    /**
     * @param value The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("hktddxlgvolsfnad")
    public suspend fun timePeriod(`value`: BudgetTimePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    /**
     * @param argument The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Required for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("mdaiygvlbavmfvvm")
    public suspend fun timePeriod(argument: suspend BudgetTimePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = BudgetTimePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timePeriod = mapped
    }

    internal fun build(): BudgetArgs = BudgetArgs(
        amount = amount,
        budgetName = budgetName,
        category = category,
        eTag = eTag,
        filter = filter,
        notifications = notifications,
        scope = scope,
        timeGrain = timeGrain,
        timePeriod = timePeriod,
    )
}
