@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ConnectorArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ConnectorStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Connector model definition
 * Azure REST API version: 2018-08-01-preview.
 * ## Example Usage
 * ### Connector_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.CostManagement.Connector("connector", new()
 *     {
 *         ConnectorName = "AWSBillingAccount",
 *         CredentialsKey = "arn:aws:iam::123456789012:role/AzureCostManagementRole",
 *         CredentialsSecret = "external-id",
 *         DisplayName = "AWS-Consolidated-1",
 *         Location = "westus",
 *         ReportId = "HourlyWithResources",
 *         ResourceGroupName = "rg1",
 *         Status = "active",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewConnector(ctx, "connector", &costmanagement.ConnectorArgs{
 * 			ConnectorName:     pulumi.String("AWSBillingAccount"),
 * 			CredentialsKey:    pulumi.String("arn:aws:iam::123456789012:role/AzureCostManagementRole"),
 * 			CredentialsSecret: pulumi.String("external-id"),
 * 			DisplayName:       pulumi.String("AWS-Consolidated-1"),
 * 			Location:          pulumi.String("westus"),
 * 			ReportId:          pulumi.String("HourlyWithResources"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Status:            pulumi.String("active"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Connector;
 * import com.pulumi.azurenative.costmanagement.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .connectorName("AWSBillingAccount")
 *             .credentialsKey("arn:aws:iam::123456789012:role/AzureCostManagementRole")
 *             .credentialsSecret("external-id")
 *             .displayName("AWS-Consolidated-1")
 *             .location("westus")
 *             .reportId("HourlyWithResources")
 *             .resourceGroupName("rg1")
 *             .status("active")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:Connector AWSBillingAccount /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.CostManagement/connectors/{connectorName}
 * ```
 * @property connectorName Connector Name.
 * @property credentialsKey Credentials authentication key (eg AWS ARN)
 * @property credentialsSecret Credentials secret (eg AWS ExternalId)
 * @property displayName Connector DisplayName (defaults to Name)
 * @property kind Connector kind (eg aws)
 * @property location Connector location
 * @property reportId Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
 * @property resourceGroupName Azure Resource Group Name.
 * @property status Connector status
 * @property tags Resource tags.
 */
public data class ConnectorArgs(
    public val connectorName: Output<String>? = null,
    public val credentialsKey: Output<String>? = null,
    public val credentialsSecret: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val reportId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<Either<String, ConnectorStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ConnectorArgs =
        com.pulumi.azurenative.costmanagement.ConnectorArgs.builder()
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .credentialsKey(credentialsKey?.applyValue({ args0 -> args0 }))
            .credentialsSecret(credentialsSecret?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .reportId(reportId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var connectorName: Output<String>? = null

    private var credentialsKey: Output<String>? = null

    private var credentialsSecret: Output<String>? = null

    private var displayName: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var reportId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<Either<String, ConnectorStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Connector Name.
     */
    @JvmName("ldqqijnnawimmfho")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value Credentials authentication key (eg AWS ARN)
     */
    @JvmName("amuohdhlmaegceul")
    public suspend fun credentialsKey(`value`: Output<String>) {
        this.credentialsKey = value
    }

    /**
     * @param value Credentials secret (eg AWS ExternalId)
     */
    @JvmName("lyxhdvcmlqbwapai")
    public suspend fun credentialsSecret(`value`: Output<String>) {
        this.credentialsSecret = value
    }

    /**
     * @param value Connector DisplayName (defaults to Name)
     */
    @JvmName("hlnrgegfjyykgchg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Connector kind (eg aws)
     */
    @JvmName("iphifpnmoseujsly")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Connector location
     */
    @JvmName("gjsnkxirnbxelbxc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    @JvmName("xsxcryeimjnfrgfr")
    public suspend fun reportId(`value`: Output<String>) {
        this.reportId = value
    }

    /**
     * @param value Azure Resource Group Name.
     */
    @JvmName("snynrvggoxjctjvu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Connector status
     */
    @JvmName("htucadhhpiroagmp")
    public suspend fun status(`value`: Output<Either<String, ConnectorStatus>>) {
        this.status = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xjxhghdxhmisqewt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Connector Name.
     */
    @JvmName("hruerpwkxbnjfems")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value Credentials authentication key (eg AWS ARN)
     */
    @JvmName("nrhensriffeglvbj")
    public suspend fun credentialsKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsKey = mapped
    }

    /**
     * @param value Credentials secret (eg AWS ExternalId)
     */
    @JvmName("mthablbjxtthrdlv")
    public suspend fun credentialsSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialsSecret = mapped
    }

    /**
     * @param value Connector DisplayName (defaults to Name)
     */
    @JvmName("twgoihxranpvkwml")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Connector kind (eg aws)
     */
    @JvmName("seatuajpyrjeupxr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Connector location
     */
    @JvmName("mmvrgnohvrhyadhm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    @JvmName("wtnksiaqrqdgxjed")
    public suspend fun reportId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportId = mapped
    }

    /**
     * @param value Azure Resource Group Name.
     */
    @JvmName("xlxsgttiyhohabaj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Connector status
     */
    @JvmName("noartcqdyfiuuccy")
    public suspend fun status(`value`: Either<String, ConnectorStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Connector status
     */
    @JvmName("qyulqwikcqtboclx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Connector status
     */
    @JvmName("qrnildipckmrbjqi")
    public fun status(`value`: ConnectorStatus) {
        val toBeMapped = Either.ofRight<String, ConnectorStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xyxiwcbwxaxsbtam")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nhsyvraeoyfwncdc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        connectorName = connectorName,
        credentialsKey = credentialsKey,
        credentialsSecret = credentialsSecret,
        displayName = displayName,
        kind = kind,
        location = location,
        reportId = reportId,
        resourceGroupName = resourceGroupName,
        status = status,
        tags = tags,
    )
}
