@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Chart type of the main view in Cost Analysis. Required.
 */
public enum class ChartType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ChartType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ChartType> {
    Area(com.pulumi.azurenative.costmanagement.enums.ChartType.Area),
    Line(com.pulumi.azurenative.costmanagement.enums.ChartType.Line),
    StackedColumn(com.pulumi.azurenative.costmanagement.enums.ChartType.StackedColumn),
    GroupedColumn(com.pulumi.azurenative.costmanagement.enums.ChartType.GroupedColumn),
    Table(com.pulumi.azurenative.costmanagement.enums.ChartType.Table),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ChartType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ChartType): ChartType =
            ChartType.values().first { it.javaValue == javaType }
    }
}
