@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Frequency of the schedule.
 */
public enum class ScheduleFrequency(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency> {
    /**
     * Cost analysis data will be emailed every day.
     */
    Daily(com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency.Daily),

    /**
     * Cost analysis data will be emailed every week.
     */
    Weekly(com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency.Weekly),

    /**
     * Cost analysis data will be emailed every month.
     */
    Monthly(com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency.Monthly),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.ScheduleFrequency):
            ScheduleFrequency = ScheduleFrequency.values().first { it.javaValue == javaType }
    }
}
