@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The time covered by a budget. Tracking of the amount will be reset based on the time grain.
 * Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Supported timeGrainTypes for **CategoryType: Cost**
 * - Monthly
 * - Quarterly
 * - Annually
 * - BillingMonth*
 * - BillingQuarter*
 * - BillingAnnual*
 *   *only supported for Web Direct customers.
 *  Supported timeGrainTypes for **CategoryType: ReservationUtilization**
 * - Last7Days
 * - Last30Days
 *  Required for CategoryType(s): Cost, ReservationUtilization.
 */
public enum class TimeGrainType(
    public val javaValue: com.pulumi.azurenative.costmanagement.enums.TimeGrainType,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.enums.TimeGrainType> {
    /**
     * The budget will track costs in the current calendar month against the amount.
     *  Supported for CategoryType: Cost only.
     */
    Monthly(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.Monthly),

    /**
     * The budget will track costs in the current calendar quarter against the amount.
     *  Supported for CategoryType: Cost only.
     */
    Quarterly(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.Quarterly),

    /**
     * The budget will track costs in the current calendar year against the amount.
     *  Supported for CategoryType: Cost only.
     */
    Annually(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.Annually),

    /**
     * The budget will track costs in the current billing month against the amount.
     *  Supported for CategoryType: Cost and Web Direct customers only.
     */
    BillingMonth(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.BillingMonth),

    /**
     * The budget will track costs in the current billing quarter against the amount.
     *  Supported for CategoryType: Cost and Web Direct customers only.
     */
    BillingQuarter(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.BillingQuarter),

    /**
     * The budget will track costs in the current billing year against the amount.
     *  Supported for CategoryType: Cost and Web Direct customers only.
     */
    BillingAnnual(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.BillingAnnual),

    /**
     * The Reservation Utilization Alert Rule will evaluate reservations based on their 7-Day utilization percentage.
     *  Supported for CategoryType: ReservationUtilization only.
     */
    Last7Days(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.Last7Days),

    /**
     * The Reservation Utilization Alert Rule will evaluate reservations based on their 30-Day utilization percentage.
     *  Supported for CategoryType: ReservationUtilization only.
     */
    Last30Days(com.pulumi.azurenative.costmanagement.enums.TimeGrainType.Last30Days),
    ;

    override fun toJava(): com.pulumi.azurenative.costmanagement.enums.TimeGrainType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.enums.TimeGrainType):
            TimeGrainType = TimeGrainType.values().first { it.javaValue == javaType }
    }
}
