@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.CostAllocationProportionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Target resources and allocation
 * @property name Target resource for cost allocation
 * @property percentage Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
 */
public data class CostAllocationProportionArgs(
    public val name: Output<String>,
    public val percentage: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.CostAllocationProportionArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.CostAllocationProportionArgs =
        com.pulumi.azurenative.costmanagement.inputs.CostAllocationProportionArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .percentage(percentage.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CostAllocationProportionArgs].
 */
@PulumiTagMarker
public class CostAllocationProportionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var percentage: Output<Double>? = null

    /**
     * @param value Target resource for cost allocation
     */
    @JvmName("ogfwqbdannjgakij")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
     */
    @JvmName("hwovfkijhforxdab")
    public suspend fun percentage(`value`: Output<Double>) {
        this.percentage = value
    }

    /**
     * @param value Target resource for cost allocation
     */
    @JvmName("kmvfcgkdfjytdlhl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
     */
    @JvmName("vtoacqbopaxxsxlw")
    public suspend fun percentage(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentage = mapped
    }

    internal fun build(): CostAllocationProportionArgs = CostAllocationProportionArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        percentage = percentage ?: throw PulumiNullFieldException("percentage"),
    )
}
