@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.RuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a cost allocation rule
 * @property description Description of a cost allocation rule.
 * @property details Resource information for the cost allocation rule
 * @property status Status of the rule
 */
public data class CostAllocationRulePropertiesArgs(
    public val description: Output<String>? = null,
    public val details: Output<CostAllocationRuleDetailsArgs>,
    public val status: Output<Either<String, RuleStatus>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .details(details.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CostAllocationRulePropertiesArgs].
 */
@PulumiTagMarker
public class CostAllocationRulePropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var details: Output<CostAllocationRuleDetailsArgs>? = null

    private var status: Output<Either<String, RuleStatus>>? = null

    /**
     * @param value Description of a cost allocation rule.
     */
    @JvmName("tdbqnjameinlwnvi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Resource information for the cost allocation rule
     */
    @JvmName("ydsyipnwiggpqdpc")
    public suspend fun details(`value`: Output<CostAllocationRuleDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value Status of the rule
     */
    @JvmName("lhrxmdcyoebgwbuf")
    public suspend fun status(`value`: Output<Either<String, RuleStatus>>) {
        this.status = value
    }

    /**
     * @param value Description of a cost allocation rule.
     */
    @JvmName("hcgasoccleuktbfx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Resource information for the cost allocation rule
     */
    @JvmName("naocoksniijtbkbn")
    public suspend fun details(`value`: CostAllocationRuleDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument Resource information for the cost allocation rule
     */
    @JvmName("siypgjokgflvhaek")
    public suspend fun details(argument: suspend CostAllocationRuleDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = CostAllocationRuleDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param value Status of the rule
     */
    @JvmName("rmnplxupfrgrwqbo")
    public suspend fun status(`value`: Either<String, RuleStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the rule
     */
    @JvmName("ntpvapmnosfnjkov")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the rule
     */
    @JvmName("oaiucqetymuoqobq")
    public fun status(`value`: RuleStatus) {
        val toBeMapped = Either.ofRight<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): CostAllocationRulePropertiesArgs = CostAllocationRulePropertiesArgs(
        description = description,
        details = details ?: throw PulumiNullFieldException("details"),
        status = status ?: throw PulumiNullFieldException("status"),
    )
}
