@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The customer billing metadata
 * @property billingAccountId Customer billing account id
 * @property billingProfileId Customer billing profile id
 */
public data class CustomerMetadataArgs(
    public val billingAccountId: Output<String>,
    public val billingProfileId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs =
        com.pulumi.azurenative.costmanagement.inputs.CustomerMetadataArgs.builder()
            .billingAccountId(billingAccountId.applyValue({ args0 -> args0 }))
            .billingProfileId(billingProfileId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerMetadataArgs].
 */
@PulumiTagMarker
public class CustomerMetadataArgsBuilder internal constructor() {
    private var billingAccountId: Output<String>? = null

    private var billingProfileId: Output<String>? = null

    /**
     * @param value Customer billing account id
     */
    @JvmName("dkpxkwvluxwdommc")
    public suspend fun billingAccountId(`value`: Output<String>) {
        this.billingAccountId = value
    }

    /**
     * @param value Customer billing profile id
     */
    @JvmName("hlaukoykgplwtmoh")
    public suspend fun billingProfileId(`value`: Output<String>) {
        this.billingProfileId = value
    }

    /**
     * @param value Customer billing account id
     */
    @JvmName("yiresjaqlmufpubu")
    public suspend fun billingAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingAccountId = mapped
    }

    /**
     * @param value Customer billing profile id
     */
    @JvmName("legergbiowmfpnnr")
    public suspend fun billingProfileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.billingProfileId = mapped
    }

    internal fun build(): CustomerMetadataArgs = CustomerMetadataArgs(
        billingAccountId = billingAccountId ?: throw PulumiNullFieldException("billingAccountId"),
        billingProfileId = billingProfileId ?: throw PulumiNullFieldException("billingProfileId"),
    )
}
