@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportDatasetArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.GranularityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The definition for data in the export.
 * @property configuration The export dataset configuration.
 * @property granularity The granularity of rows in the export. Currently only 'Daily' is supported.
 */
public data class ExportDatasetArgs(
    public val configuration: Output<ExportDatasetConfigurationArgs>? = null,
    public val granularity: Output<Either<String, GranularityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportDatasetArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportDatasetArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .granularity(
                granularity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportDatasetArgs].
 */
@PulumiTagMarker
public class ExportDatasetArgsBuilder internal constructor() {
    private var configuration: Output<ExportDatasetConfigurationArgs>? = null

    private var granularity: Output<Either<String, GranularityType>>? = null

    /**
     * @param value The export dataset configuration.
     */
    @JvmName("jhhpjwxdhfarknql")
    public suspend fun configuration(`value`: Output<ExportDatasetConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value The granularity of rows in the export. Currently only 'Daily' is supported.
     */
    @JvmName("jhqcqxkiaycdlftb")
    public suspend fun granularity(`value`: Output<Either<String, GranularityType>>) {
        this.granularity = value
    }

    /**
     * @param value The export dataset configuration.
     */
    @JvmName("bggpafpjgxolaiid")
    public suspend fun configuration(`value`: ExportDatasetConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument The export dataset configuration.
     */
    @JvmName("jqflyguvwvokbmsu")
    public suspend
    fun configuration(argument: suspend ExportDatasetConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExportDatasetConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value The granularity of rows in the export. Currently only 'Daily' is supported.
     */
    @JvmName("wtxhvoyiixebfjqr")
    public suspend fun granularity(`value`: Either<String, GranularityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the export. Currently only 'Daily' is supported.
     */
    @JvmName("afjjpmubkdyptmsg")
    public fun granularity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the export. Currently only 'Daily' is supported.
     */
    @JvmName("tcaadjkmbergmsrh")
    public fun granularity(`value`: GranularityType) {
        val toBeMapped = Either.ofRight<String, GranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    internal fun build(): ExportDatasetArgs = ExportDatasetArgs(
        configuration = configuration,
        granularity = granularity,
    )
}
