@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.FileDestinationArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.FileFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Destination of the view data. This is optional. Currently only CSV format is supported.
 * @property fileFormats Destination of the view data. Currently only CSV format is supported.
 */
public data class FileDestinationArgs(
    public val fileFormats: Output<List<Either<String, FileFormat>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.FileDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.FileDestinationArgs =
        com.pulumi.azurenative.costmanagement.inputs.FileDestinationArgs.builder()
            .fileFormats(
                fileFormats?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [FileDestinationArgs].
 */
@PulumiTagMarker
public class FileDestinationArgsBuilder internal constructor() {
    private var fileFormats: Output<List<Either<String, FileFormat>>>? = null

    /**
     * @param value Destination of the view data. Currently only CSV format is supported.
     */
    @JvmName("fbncnkvikgvurxwr")
    public suspend fun fileFormats(`value`: Output<List<Either<String, FileFormat>>>) {
        this.fileFormats = value
    }

    @JvmName("peciufkbyitlrddd")
    public suspend fun fileFormats(vararg values: Output<Either<String, FileFormat>>) {
        this.fileFormats = Output.all(values.asList())
    }

    /**
     * @param values Destination of the view data. Currently only CSV format is supported.
     */
    @JvmName("ilqiykfsccdvanda")
    public suspend fun fileFormats(values: List<Output<Either<String, FileFormat>>>) {
        this.fileFormats = Output.all(values)
    }

    /**
     * @param value Destination of the view data. Currently only CSV format is supported.
     */
    @JvmName("riyvwkueyjtcdrsj")
    public suspend fun fileFormats(`value`: List<Either<String, FileFormat>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileFormats = mapped
    }

    /**
     * @param values Destination of the view data. Currently only CSV format is supported.
     */
    @JvmName("pnwjhfqjdtjfwibo")
    public suspend fun fileFormats(vararg values: Either<String, FileFormat>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileFormats = mapped
    }

    internal fun build(): FileDestinationArgs = FileDestinationArgs(
        fileFormats = fileFormats,
    )
}
